/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.AbstractNegatedToken;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.NegatedToken;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.UntilToken;

public class GrammarAnalyzer {
    private final String XbasePackageNS_URI = "http://www.eclipse.org/xtext/xbase/Xbase";
    private List<CommentRule> commentRules;
    private final Grammar grammar;

    public GrammarAnalyzer(Grammar grammar) {
        this.grammar = grammar;
    }

    protected List<String> collectChars(AbstractElement ele) {
        String value;
        if (GrammarUtil.isOptionalCardinality((AbstractElement)(ele = this.resolve(ele)))) {
            return Collections.emptyList();
        }
        if (ele instanceof Keyword && !"\r".equals(value = ((Keyword)ele).getValue())) {
            return Collections.singletonList(value);
        }
        if (ele instanceof Group) {
            return this.collectChars((Group)ele, 0, ((Group)ele).getElements().size());
        }
        if (ele instanceof Alternatives) {
            ArrayList current = Lists.newArrayList();
            for (AbstractElement e : ((Alternatives)ele).getElements()) {
                current.addAll(this.collectChars(e));
            }
            return current;
        }
        return Collections.emptyList();
    }

    protected List<String> collectChars(Group ele, int from, int to) {
        ArrayList last = Lists.newArrayList((Object[])new String[]{""});
        ArrayList current = Lists.newArrayList();
        int i = from;
        while (i < to) {
            for (String l : last) {
                for (String append : this.collectChars((AbstractElement)ele.getElements().get(i))) {
                    current.add(String.valueOf(l) + append);
                }
            }
            last = current;
            current = Lists.newArrayList();
            ++i;
        }
        return last;
    }

    protected void collectCommentRules(AbstractElement ele, List<CommentRule> rules) {
        block14: {
            block12: {
                int index;
                List<String> starts;
                AbstractNegatedToken negated;
                Group group;
                block13: {
                    if (!((ele = this.resolve(ele)) instanceof Group)) break block12;
                    group = (Group)ele;
                    negated = null;
                    for (AbstractElement child : group.getElements()) {
                        if (!(child instanceof AbstractNegatedToken)) continue;
                        if (negated == null) {
                            negated = (AbstractNegatedToken)child;
                            continue;
                        }
                        return;
                    }
                    if (!(negated instanceof NegatedToken)) break block13;
                    int index2 = group.getElements().indexOf(negated);
                    if (index2 <= 0 || index2 >= group.getElements().size() - 1) break block14;
                    starts = this.collectChars(group, 0, index2);
                    List<String> ends = this.collectChars(group, index2 + 1, group.getElements().size());
                    if (ends.isEmpty()) {
                        for (String start : starts) {
                            rules.add(new SLCommentRule(start));
                        }
                    } else {
                        for (String start : starts) {
                            for (String end : ends) {
                                if (end.contains("\n")) {
                                    rules.add(new SLCommentRule(start));
                                    continue;
                                }
                                rules.add(new MLCommentRule(start, end));
                            }
                        }
                    }
                    break block14;
                }
                if (!(negated instanceof UntilToken) || (index = group.getElements().indexOf(negated)) != group.getElements().size() - 1) break block14;
                starts = this.collectChars(group, 0, index);
                List<String> ends = this.collectChars(((UntilToken)negated).getTerminal());
                for (String start : starts) {
                    for (String end : ends) {
                        rules.add(new MLCommentRule(start, end));
                    }
                }
                break block14;
            }
            if (ele instanceof Alternatives) {
                for (AbstractElement e : ((Alternatives)ele).getElements()) {
                    this.collectCommentRules(e, rules);
                }
            }
        }
    }

    public List<CommentRule> getCommentRules() {
        if (this.commentRules == null) {
            this.commentRules = Lists.newArrayList();
            Grammar grammarWithHiddenTokens = this.grammar;
            while (!grammarWithHiddenTokens.isDefinesHiddenTokens() && !grammarWithHiddenTokens.getUsedGrammars().isEmpty()) {
                grammarWithHiddenTokens = (Grammar)grammarWithHiddenTokens.getUsedGrammars().get(0);
            }
            if (grammarWithHiddenTokens.isDefinesHiddenTokens()) {
                for (AbstractRule rule : grammarWithHiddenTokens.getHiddenTokens()) {
                    if (!(rule instanceof TerminalRule)) continue;
                    this.collectCommentRules(rule.getAlternatives(), this.commentRules);
                }
            }
        }
        return this.commentRules;
    }

    public XtextLanguageKind getLanguageKind() {
        ArrayList grammars = Lists.newArrayList((Object[])new Grammar[]{this.grammar});
        grammars.addAll(GrammarUtil.allUsedGrammars((Grammar)this.grammar));
        boolean xbase = false;
        boolean java = false;
        for (Grammar g : grammars) {
            for (AbstractMetamodelDeclaration decl : g.getMetamodelDeclarations()) {
                if (!(decl instanceof ReferencedMetamodel)) continue;
                if (decl.getEPackage().getNsURI().equals("http://www.eclipse.org/xtext/xbase/Xbase")) {
                    xbase = true;
                    continue;
                }
                if (!decl.getEPackage().getNsURI().equals("http://www.eclipse.org/xtext/common/JavaVMTypes")) continue;
                java = true;
            }
        }
        if (xbase) {
            return XtextLanguageKind.XBASE;
        }
        if (java) {
            return XtextLanguageKind.JAVA;
        }
        return XtextLanguageKind.GENERAL;
    }

    protected AbstractElement resolve(AbstractElement ele) {
        AbstractRule rule;
        if (ele instanceof RuleCall && (rule = ((RuleCall)ele).getRule()) instanceof TerminalRule && ((TerminalRule)rule).isFragment()) {
            return rule.getAlternatives();
        }
        return ele;
    }

    public static class CommentRule {
        private final String start;

        public CommentRule(String start) {
            this.start = start;
        }

        public String getStart() {
            return this.start;
        }
    }

    public static class MLCommentRule
    extends CommentRule {
        private final String end;

        public MLCommentRule(String start, String end) {
            super(start);
            this.end = end;
        }

        public String getEnd() {
            return this.end;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + ": '" + this.getStart() + "' -> '" + this.getEnd() + "'";
        }
    }

    public static class SLCommentRule
    extends CommentRule {
        public SLCommentRule(String start) {
            super(start);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + ": '" + this.getStart() + "' -> '\n'";
        }
    }

    public static enum XtextLanguageKind {
        GENERAL,
        JAVA,
        XBASE;

    }
}

