/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.tests;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.expectation.ILinesExpectation;
import org.eclipse.xpect.expectation.LinesExpectation;
import org.eclipse.xpect.runner.LiveExecutionType;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xpect.runner.XpectRunner;
import org.eclipse.xpect.xtext.lib.setup.ThisResource;
import org.eclipse.xpect.xtext.lib.setup.XtextStandaloneSetup;
import org.eclipse.xpect.xtext.lib.setup.XtextWorkspaceSetup;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.junit.runner.RunWith;

@RunWith(value=XpectRunner.class)
@XpectImport(value={XtextStandaloneSetup.class, XtextWorkspaceSetup.class})
public class ResourceDescriptionTest {
    @Inject
    private IResourceDescription.Manager manager;

    @Xpect(liveExecution=LiveExecutionType.FAST)
    public void exportedObjects(@LinesExpectation ILinesExpectation expectation, @ThisResource XtextResource resource) {
        IResourceDescription resourceDescription = this.manager.getResourceDescription((Resource)resource);
        Iterable exportedObjects = resourceDescription.getExportedObjects();
        expectation.assertEquals(Iterables.transform((Iterable)exportedObjects, (Function)new EObjectDescriptionToStringMapper()));
    }

    @Xpect(liveExecution=LiveExecutionType.FAST)
    public void importedNames(@LinesExpectation ILinesExpectation expectation, @ThisResource XtextResource resource) {
        IResourceDescription resourceDescription = this.manager.getResourceDescription((Resource)resource);
        Iterable importedNames = resourceDescription.getImportedNames();
        expectation.assertEquals(importedNames);
    }

    @Xpect(liveExecution=LiveExecutionType.FAST)
    public void referenceDescriptions(@LinesExpectation ILinesExpectation expectation, @ThisResource XtextResource resource) {
        IResourceDescription resourceDescription = this.manager.getResourceDescription((Resource)resource);
        Iterable referenceDescriptions = resourceDescription.getReferenceDescriptions();
        expectation.assertEquals(Iterables.transform((Iterable)referenceDescriptions, (Function)new ReferenceDescriptionToStringMapper(resource.getURI())));
    }

    protected static class EObjectDescriptionToStringMapper
    implements Function<IEObjectDescription, String> {
        protected EObjectDescriptionToStringMapper() {
        }

        public String apply(IEObjectDescription desc) {
            return String.valueOf(desc.getEClass().getEPackage().getNsPrefix()) + "::" + desc.getEClass().getName() + ": " + desc.getName().toString();
        }
    }

    protected static class ReferenceDescriptionToStringMapper
    implements Function<IReferenceDescription, String> {
        private final URI base;

        public URI getBase() {
            return this.base;
        }

        public ReferenceDescriptionToStringMapper(URI base) {
            this.base = base.trimFragment();
        }

        protected String deresolve(URI uri) {
            if (this.base.equals(uri.trimFragment())) {
                return uri.fragment();
            }
            return uri.deresolve(this.base).toString();
        }

        public String apply(IReferenceDescription desc) {
            StringBuilder result = new StringBuilder();
            String container = this.deresolve(desc.getContainerEObjectURI());
            String source = this.deresolve(desc.getSourceEObjectUri());
            if (source.startsWith(container)) {
                result.append(container);
                result.append("::");
                result.append(source.substring(container.length()));
            } else {
                result.append(container);
                result.append(" <> ");
                result.append(source);
            }
            result.append(" ");
            result.append(desc.getEReference().getName());
            if (desc.getIndexInList() > 0) {
                result.append("[");
                result.append(desc.getIndexInList());
                result.append("]");
            }
            result.append(" --> ");
            result.append(this.deresolve(desc.getTargetEObjectUri()));
            return result.toString();
        }
    }
}

