/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.setup.emf;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.setup.ISetupInitializer;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.setup.XpectSetupRoot;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.xtext.lib.setup.emf.File;
import org.eclipse.xpect.xtext.lib.setup.emf.Resource;
import org.eclipse.xpect.xtext.lib.setup.emf.ResourceFactory;
import org.eclipse.xpect.xtext.lib.setup.emf.ResourceSet;
import org.eclipse.xpect.xtext.lib.setup.emf.ThisFile;
import org.eclipse.xpect.xtext.lib.setup.emf.ThisResource;
import org.eclipse.xpect.xtext.lib.setup.generic.Folder;

@XpectSetupRoot
@XpectSetupFactory
@XpectImport(value={Resource.class, ResourceSet.class, ThisResource.class, File.class, ThisFile.class})
public class ResourceSetDefaultsSetup {
    private List<org.eclipse.xpect.xtext.lib.setup.generic.Resource> genericResources = Lists.newArrayList();
    private ResourceSet resourceSet = null;

    public ResourceSetDefaultsSetup(ISetupInitializer<ResourceSetDefaultsSetup> initializer) {
        this.initialize(initializer);
    }

    public void add(org.eclipse.xpect.xtext.lib.setup.generic.Resource genericResource) {
        this.genericResources.add(genericResource);
    }

    public void add(ResourceSet resourceSet) {
        if (this.resourceSet != null) {
            throw new IllegalStateException("Only one ResourceSet can be configured");
        }
        this.resourceSet = resourceSet;
    }

    protected void addThisFileIfNeeded() {
        for (ResourceFactory fact : this.resourceSet.getFactories()) {
            if (!(fact instanceof ThisResource)) continue;
            return;
        }
        this.resourceSet.add(new ThisResource());
    }

    protected void convert(org.eclipse.xpect.xtext.lib.setup.generic.Resource res) {
        if (res instanceof org.eclipse.xpect.xtext.lib.setup.generic.ThisFile) {
            this.resourceSet.add(new ThisResource((org.eclipse.xpect.xtext.lib.setup.generic.ThisFile)res));
        } else if (res instanceof org.eclipse.xpect.xtext.lib.setup.generic.File) {
            this.resourceSet.add(new Resource((org.eclipse.xpect.xtext.lib.setup.generic.File)res));
        } else if (res instanceof Folder) {
            for (org.eclipse.xpect.xtext.lib.setup.generic.Resource child : ((Folder)res).getChildren()) {
                this.convert(child);
            }
        } else {
            throw new IllegalStateException();
        }
    }

    protected ResourceSet createResourceSet() {
        return new ResourceSet();
    }

    @Creates
    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    protected void initialize(ISetupInitializer<ResourceSetDefaultsSetup> initializer) {
        initializer.initialize((Object)this);
        if (this.resourceSet == null) {
            this.resourceSet = this.createResourceSet();
        }
        for (org.eclipse.xpect.xtext.lib.setup.generic.Resource res : this.genericResources) {
            this.convert(res);
        }
        this.addThisFileIfNeeded();
    }
}

