/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.setup;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xpect.Environment;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.XpectRequiredEnvironment;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.state.Invalidates;
import org.eclipse.xpect.xtext.lib.setup.FileSetupContext;
import org.eclipse.xpect.xtext.lib.setup.InjectorSetup;
import org.eclipse.xpect.xtext.lib.setup.ThisFile;
import org.eclipse.xpect.xtext.lib.setup.ThisProject;
import org.eclipse.xpect.xtext.lib.setup.ThisResource;
import org.eclipse.xpect.xtext.lib.setup.XtextTestObjectSetup;
import org.eclipse.xpect.xtext.lib.setup.XtextValidatingSetup;
import org.eclipse.xpect.xtext.lib.setup.workspace.Workspace;
import org.eclipse.xpect.xtext.lib.setup.workspace.WorkspaceDefaultsSetup;
import org.eclipse.xpect.xtext.lib.util.XtextOffsetAdapter;
import org.eclipse.xpect.xtext.lib.util.XtextTargetSyntaxSupport;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

@XpectSetupFactory
@XpectRequiredEnvironment(value={Environment.PLUGIN_TEST})
@XpectImport(value={WorkspaceDefaultsSetup.class, XtextTargetSyntaxSupport.class, XtextTestObjectSetup.class, InjectorSetup.class, XtextValidatingSetup.class, FileSetupContext.class, XtextOffsetAdapter.class})
public class XtextWorkspaceSetup {
    private final FileSetupContext ctx;
    private Workspace.Instance workspace;
    private final Workspace workspaceConfig;
    @Inject
    private IResourceSetProvider resourceSetProvider;

    public XtextWorkspaceSetup(FileSetupContext ctx, Workspace workspace, Injector injector) {
        this.ctx = ctx;
        this.workspaceConfig = workspace;
        injector.injectMembers((Object)this);
    }

    @Creates(value=ThisFile.class)
    public IFile createThisFile() {
        return this.getInstance().getThisFile();
    }

    @Creates(value=ThisProject.class)
    public IProject createThisProject() {
        return this.getInstance().getThisProject();
    }

    @Creates
    public IWorkspace createWorkspace() {
        return this.getInstance().getWorkspace();
    }

    protected Workspace.Instance getInstance() {
        if (this.workspace == null) {
            this.workspaceConfig.cleanWorkspace();
            this.workspace = this.workspaceConfig.configureWorkspace(this.ctx);
            if (this.workspaceConfig.isAutobuild()) {
                this.workspaceConfig.waitForAutoBuild();
            } else {
                this.workspaceConfig.buildIncrementally();
            }
        }
        return this.workspace;
    }

    public void invalidate() {
        this.workspaceConfig.cleanWorkspace();
        this.workspace = null;
    }

    @Invalidates
    public void invalidateWorkspace(IWorkspace workspace) {
        this.invalidate();
    }

    @Creates(value=ThisResource.class)
    public XtextResource createThisResource() throws IOException, CoreException {
        Workspace.Instance instance = this.getInstance();
        IFile file = instance.getThisFile();
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        ResourceSet resourceSet = this.resourceSetProvider.get(instance.getThisProject());
        XtextResource resource = (XtextResource)this.ctx.load(resourceSet, uri, file.getContents());
        return resource;
    }
}

