/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.setup;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xpect.XpectReplace;
import org.eclipse.xpect.runner.ValidatingSetup;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.util.IssueVisualizer;
import org.eclipse.xpect.xtext.lib.setup.ThisResource;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IDiagnosticConverter;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.junit.ComparisonFailure;

@XpectSetupFactory
@XpectReplace(value={ValidatingSetup.class})
public class XtextValidatingSetup
extends ValidatingSetup {
    private List<Issue> issues = null;
    private final XtextResource resource;

    public XtextValidatingSetup(@ThisResource XtextResource resource) {
        this.resource = resource;
    }

    protected List<Issue> collectIssues() {
        if (this.isResolveAllReferences()) {
            EcoreUtil.resolveAll((Resource)this.resource);
        }
        if (this.isValidate()) {
            return this.collectIssuesFromValidator();
        }
        return this.collectIssuesFromResource();
    }

    private List<Issue> collectIssuesFromResource() {
        ArrayList result = Lists.newArrayList();
        IDiagnosticConverter converer = (IDiagnosticConverter)this.resource.getResourceServiceProvider().get(IDiagnosticConverter.class);
        for (Resource.Diagnostic diagnostic : this.resource.getErrors()) {
            converer.convertResourceDiagnostic(diagnostic, Severity.ERROR, new ListAcceptor(result));
        }
        for (Resource.Diagnostic diagnostic : this.resource.getWarnings()) {
            converer.convertResourceDiagnostic(diagnostic, Severity.WARNING, new ListAcceptor(result));
        }
        return result;
    }

    private List<Issue> collectIssuesFromValidator() {
        IResourceValidator validator = this.resource.getResourceServiceProvider().getResourceValidator();
        return validator.validate((Resource)this.resource, CheckMode.ALL, CancelIndicator.NullImpl);
    }

    @Creates
    public ValidatingSetup create() {
        return this;
    }

    public List<Issue> getIssues() {
        if (this.issues == null) {
            ArrayList issues = Lists.newArrayList();
            for (Issue issue : this.collectIssues()) {
                if (!this.includeIssue(issue)) continue;
                issues.add(issue);
            }
            this.issues = ImmutableList.copyOf((Collection)issues);
        }
        return this.issues;
    }

    protected XtextResource getResource() {
        return this.resource;
    }

    protected boolean includeIssue(Issue issue) {
        return true;
    }

    public boolean isResolveAllReferences() {
        return true;
    }

    public boolean isValidate() {
        return true;
    }

    public void validate() {
        List<Issue> issues = this.getIssues();
        if (issues.isEmpty()) {
            return;
        }
        String document = this.resource.getParseResult().getRootNode().getText();
        String visualized = new IssueVisualizer().visualize(document, issues);
        throw new ComparisonFailure(Joiner.on((String)"\n").join(issues), document, visualized);
    }

    protected static class ListAcceptor<T>
    implements IAcceptor<T> {
        private List<T> list;

        public ListAcceptor(List<T> list) {
            this.list = list;
        }

        public void accept(T t) {
            this.list.add(t);
        }
    }
}

