/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.config;

import java.net.URL;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.sso.boschid.EidpUtils;
import org.eclipse.vorto.repository.upgrade.IUpgradeService;
import org.eclipse.vorto.repository.upgrade.impl.DefaultUpgradeService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;

@Configuration
public class RepositoryConfiguration {
    @Value(value="${http.proxyHost:#{null}}")
    String proxyHost;
    @Value(value="${http.proxyPort:8080}")
    protected int proxyPort;
    @Value(value="${http.proxyUser:#{null}}")
    private String proxyUsername;
    @Value(value="${http.proxyPassword:#{null}}")
    private String proxyPassword;
    @Value(value="${repo.configFile}")
    private String repositoryConfigFile = null;

    @Bean
    public org.modeshape.jcr.RepositoryConfiguration repoConfiguration() throws Exception {
        return org.modeshape.jcr.RepositoryConfiguration.read((URL)new ClassPathResource(this.repositoryConfigFile).getURL());
    }

    @Bean
    public AccessTokenProvider accessTokenProvider() {
        if (this.proxyHost != null) {
            return EidpUtils.proxiedAccessTokenProvider((String)this.proxyHost, (int)this.proxyPort, (String)this.proxyUsername, (String)this.proxyPassword);
        }
        return EidpUtils.accessTokenProvider();
    }

    @Bean
    public IUpgradeService upgradeService(IModelRepository modelRepository) {
        DefaultUpgradeService upgradeService = new DefaultUpgradeService();
        return upgradeService;
    }
}

