/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.config;

import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.web.security.IsModelAuthorEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.method.configuration.GlobalMethodSecurityConfiguration;

@Configuration
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class MethodSecurityConfig
extends GlobalMethodSecurityConfiguration {
    @Autowired
    private IModelRepository repository;

    public MethodSecurityConfig() {
    }

    @Autowired
    public MethodSecurityConfig(IModelRepository repository) {
        this.repository = repository;
    }

    protected MethodSecurityExpressionHandler createExpressionHandler() {
        DefaultMethodSecurityExpressionHandler expressionHandler = new DefaultMethodSecurityExpressionHandler();
        expressionHandler.setPermissionEvaluator((PermissionEvaluator)new IsModelAuthorEvaluator(this.repository));
        return expressionHandler;
    }
}

