/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.security;

import java.util.Collection;
import javax.transaction.Transactional;
import org.eclipse.vorto.repository.service.IUserRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class UsersDetailsServiceImpl
implements UserDetailsService {
    @Autowired
    private IUserRepository userRepository;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        org.eclipse.vorto.repository.model.User user = this.userRepository.findByUsername(username);
        if (user == null) {
            throw new UsernameNotFoundException("No user found with username: " + username);
        }
        boolean enabled = true;
        boolean accountNonExpired = true;
        boolean credentialsNonExpired = true;
        boolean accountNonLocked = true;
        return new User(user.getUsername(), user.getPassword(), enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_" + user.getRole().toString()}));
    }
}

