/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.generation.GeneratedOutput;
import org.eclipse.vorto.repository.api.generation.GeneratorInfo;
import org.eclipse.vorto.repository.api.generation.ServiceClassifier;
import org.eclipse.vorto.repository.service.IGeneratorService;
import org.eclipse.vorto.repository.web.AbstractRepositoryController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="/generate", description="Generate code from information models")
@RestController
@RequestMapping(value={"/rest/generation-router"})
public class ModelGenerationController
extends AbstractRepositoryController {
    private static final String ATTACHMENT_FILENAME = "attachment; filename = ";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String CONTENT_DISPOSITION = "content-disposition";
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelGenerationController.class);
    @Autowired
    private IGeneratorService generatorService;

    @ApiOperation(value="Generate code for a specified platform")
    @ApiResponses(value={@ApiResponse(code=400, message="Wrong input"), @ApiResponse(code=404, message="Model not found")})
    @RequestMapping(value={"/{namespace}/{name}/{version:.+}/{serviceKey}"}, method={RequestMethod.GET})
    public void generate(@ApiParam(value="The namespace of vorto model, e.g. com.mycompany", required=true) @PathVariable String namespace, @ApiParam(value="The name of vorto model, e.g. NewInfomodel", required=true) @PathVariable String name, @ApiParam(value="The version of vorto model, e.g. 1.0.0", required=true) @PathVariable String version, @ApiParam(value="Service key for a specified platform, e.g. lwm2m", required=true) @PathVariable String serviceKey, HttpServletRequest request, HttpServletResponse response) {
        Objects.requireNonNull(namespace, "namespace must not be null");
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(version, "version must not be null");
        HashMap requestParams = new HashMap();
        request.getParameterMap().entrySet().stream().forEach(x -> requestParams.put(x.getKey(), ((String[])x.getValue())[0]));
        try {
            GeneratedOutput generatedOutput = this.generatorService.generate(new ModelId(name, namespace, version), URLDecoder.decode(serviceKey, "utf-8"), requestParams);
            response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + generatedOutput.getFileName());
            response.setContentLengthLong(generatedOutput.getSize());
            response.setContentType(APPLICATION_OCTET_STREAM);
            IOUtils.copy((InputStream)new ByteArrayInputStream(generatedOutput.getContent()), (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException("Error copying file.", e);
        }
    }

    @ApiOperation(value="Returns all currently registered Code Generator")
    @RequestMapping(value={"/{classifier}"}, method={RequestMethod.GET}, produces={"application/json"})
    public Collection<GeneratorInfo> getRegisteredGeneratorServices(@ApiParam(value="Choose type of generator", allowableValues="platform,documentation", required=true) @PathVariable String classifier, @ApiParam(value="Prioritize results with given tag", allowableValues="any given tags", required=false) @RequestParam(value="orderBy", required=false, defaultValue="production") String orderBy) {
        ArrayList<GeneratorInfo> generatorInfoResult = new ArrayList<GeneratorInfo>();
        for (String serviceKey : this.generatorService.getRegisteredGeneratorServiceKeys(ServiceClassifier.valueOf((String)classifier))) {
            try {
                generatorInfoResult.add(this.generatorService.getGeneratorServiceInfo(serviceKey));
            }
            catch (Throwable t) {
                LOGGER.warn("Generator " + serviceKey + " appears to be offline or not deployed. Skipping...");
            }
        }
        generatorInfoResult.sort((genInfo1, genInfo2) -> {
            if (this.contains(genInfo1.getTags(), orderBy) ^ this.contains(genInfo2.getTags(), orderBy)) {
                if (this.contains(genInfo1.getTags(), orderBy)) {
                    return -1;
                }
                return 1;
            }
            return genInfo1.getName().compareTo(genInfo2.getName());
        });
        return generatorInfoResult;
    }

    private boolean contains(String[] tags, String tag) {
        if (tags != null) {
            for (String _tag : tags) {
                if (!_tag.equals(tag)) continue;
                return true;
            }
        }
        return false;
    }

    @ApiOperation(value="Returns the rank of code generators by usage")
    @RequestMapping(value={"/topused/{top}"}, method={RequestMethod.GET}, produces={"application/json"})
    public Collection<GeneratorInfo> getMostlyUsedGenerators(@ApiParam(value="The upper limit number of top code generator list", required=true) @PathVariable int top) {
        return this.generatorService.getMostlyUsedGenerators(top);
    }

    @ApiOperation(value="Register a code generator", hidden=true)
    @RequestMapping(value={"/register/{serviceKey}/{classifier}"}, method={RequestMethod.PUT})
    public void registerGenerator(@ApiParam(value="Service key for a specified platform, e.g. lwm2m", required=true) @PathVariable String serviceKey, @ApiParam(value="Service type for a specified code generator, e.g. platform", required=true) @PathVariable ServiceClassifier classifier, @ApiParam(value="The URL links to a specified code generator", required=true) @RequestBody String baseUrl) {
        this.generatorService.registerGenerator(serviceKey, baseUrl, classifier);
    }

    @ApiOperation(value="Deregister a code generator", hidden=true)
    @RequestMapping(value={"/deregister/{serviceKey}"}, method={RequestMethod.PUT})
    public boolean deregisterGenerator(@ApiParam(value="Service key for a specified platform, e.g. lwm2m", required=true) @PathVariable String serviceKey) {
        this.generatorService.unregisterGenerator(serviceKey);
        return true;
    }
}

