/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.service.IRepositoryManager;
import org.eclipse.vorto.repository.web.AbstractRepositoryController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/rest/admin"})
public class AdminController
extends AbstractRepositoryController {
    @Autowired
    private IRepositoryManager repositoryManager;
    private static final String ATTACHMENT_FILENAME = "attachment; filename = ";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String CONTENT_DISPOSITION = "content-disposition";
    private static final SimpleDateFormat SIMPLEDATEFORMAT = new SimpleDateFormat("yyyyMMdd-HH:mm");

    @RequestMapping(value={"/{namespace}/{name}/{version:.+}"}, method={RequestMethod.DELETE})
    @Secured(value={"ROLE_ADMIN"})
    public void deleteModelResource(@PathVariable String namespace, @PathVariable String name, @PathVariable String version) {
        Objects.requireNonNull(namespace, "namespace must not be null");
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(version, "version must not be null");
        this.repositoryManager.removeModel(new ModelId(name, namespace, version));
    }

    @RequestMapping(value={"/content"}, method={RequestMethod.GET})
    @Secured(value={"ROLE_ADMIN"})
    public void backupRepository(HttpServletResponse response) throws Exception {
        byte[] backup = this.repositoryManager.backup();
        response.setHeader(CONTENT_DISPOSITION, "attachment; filename = vortobackup_" + SIMPLEDATEFORMAT.format(new Date()) + ".xml");
        response.setContentLengthLong((long)backup.length);
        response.setContentType(APPLICATION_OCTET_STREAM);
        try {
            IOUtils.copy((InputStream)new ByteArrayInputStream(backup), (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException("Error copying file.", e);
        }
    }

    @RequestMapping(value={"/content"}, method={RequestMethod.POST})
    @Secured(value={"ROLE_ADMIN"})
    public void restoreRepository(@RequestParam(value="file") MultipartFile file) throws Exception {
        this.repositoryManager.restore(file.getBytes());
    }
}

