/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.internal.service;

import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.vorto.repository.internal.service.IModelParser;
import org.eclipse.vorto.repository.internal.service.emf.DatatypeModelParser;
import org.eclipse.vorto.repository.internal.service.emf.FunctionblockModelParser;
import org.eclipse.vorto.repository.internal.service.emf.InformationModelParser;
import org.eclipse.vorto.repository.internal.service.emf.MappingModelParser;

public class ModelParserFactory {
    public static IModelParser getParser(String fileName) {
        if (fileName.endsWith(ModelType.Datatype.getExtension())) {
            return new DatatypeModelParser(fileName);
        }
        if (fileName.endsWith(ModelType.Functionblock.getExtension())) {
            return new FunctionblockModelParser(fileName);
        }
        if (fileName.endsWith(ModelType.InformationModel.getExtension())) {
            return new InformationModelParser(fileName);
        }
        if (fileName.endsWith(ModelType.Mapping.getExtension())) {
            return new MappingModelParser(fileName);
        }
        throw new UnsupportedOperationException("File cannot be parsed, because it is not supported");
    }
}

