/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.workflow.impl;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.vorto.repository.account.impl.IUserRepository;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.core.IUserContext;
import org.eclipse.vorto.repository.workflow.IWorkflowService;
import org.eclipse.vorto.repository.workflow.InvalidInputException;
import org.eclipse.vorto.repository.workflow.WorkflowException;
import org.eclipse.vorto.repository.workflow.impl.SimpleWorkflowModel;
import org.eclipse.vorto.repository.workflow.model.IAction;
import org.eclipse.vorto.repository.workflow.model.IState;
import org.eclipse.vorto.repository.workflow.model.IWorkflowCondition;
import org.eclipse.vorto.repository.workflow.model.IWorkflowModel;
import org.eclipse.vorto.repository.workflow.model.IWorkflowValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultWorkflowService
implements IWorkflowService {
    @Autowired
    private IModelRepository modelRepository;
    private IWorkflowModel SIMPLE_WORKFLOW = null;

    public DefaultWorkflowService(@Autowired IModelRepository modelRepository, @Autowired IUserRepository userRepository) {
        this.modelRepository = modelRepository;
        this.SIMPLE_WORKFLOW = new SimpleWorkflowModel(userRepository, modelRepository);
    }

    @Override
    public ModelInfo doAction(ModelId model, IUserContext user, String actionName) throws WorkflowException {
        ModelInfo modelInfo = this.modelRepository.getById(model);
        Optional<IState> state = this.SIMPLE_WORKFLOW.getState(modelInfo.getState());
        Optional<IAction> action = state.get().getAction(actionName);
        if (action.isPresent() && this.isValidInput(modelInfo, action.get()) && this.passesConditions(action.get().getConditions(), modelInfo, user)) {
            IState newState = action.get().getTo();
            modelInfo.setState(newState.getName());
            return this.modelRepository.updateMeta(modelInfo);
        }
        throw new WorkflowException(modelInfo, "The given action is invalid.");
    }

    private boolean isValidInput(ModelInfo modelInfo, IAction action) throws InvalidInputException {
        for (IWorkflowValidator validator : action.getValidators()) {
            validator.validate(modelInfo, action);
        }
        return true;
    }

    @Override
    public List<String> getPossibleActions(ModelId model, IUserContext user) {
        ModelInfo modelInfo = this.modelRepository.getById(model);
        Optional<IState> state = this.SIMPLE_WORKFLOW.getState(modelInfo.getState());
        return state.get().getActions().stream().filter(action -> this.passesConditions(action.getConditions(), modelInfo, user)).map(t -> t.getName()).collect(Collectors.toList());
    }

    private boolean passesConditions(List<IWorkflowCondition> conditions, ModelInfo model, IUserContext user) {
        for (IWorkflowCondition condition : conditions) {
            if (condition.passesCondition(model, user)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<ModelInfo> getModelsByState(String state) {
        return this.modelRepository.search("state:" + state);
    }

    public IModelRepository getModelRepository() {
        return this.modelRepository;
    }

    public void setModelRepository(IModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    @Override
    public ModelId start(ModelId modelId) {
        IState nextState = this.SIMPLE_WORKFLOW.getInitialAction().getTo();
        return this.modelRepository.updateState(modelId, nextState.getName());
    }

    @Override
    public Optional<IState> getStateModel(ModelId model) {
        ModelInfo modelInfo = this.modelRepository.getById(model);
        return this.SIMPLE_WORKFLOW.getState(modelInfo.getState());
    }
}

