/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.core.validation;

import java.util.Map;
import org.eclipse.vorto.mapping.engine.normalized.FunctionblockData;
import org.eclipse.vorto.mapping.engine.normalized.InfomodelData;
import org.eclipse.vorto.mapping.engine.spec.IMappingSpecification;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.content.FunctionblockModel;
import org.eclipse.vorto.repository.api.content.ModelProperty;
import org.eclipse.vorto.repository.api.content.PrimitiveType;
import org.eclipse.vorto.repository.web.core.validation.ValidationProblem;

public class ValidationHelper {
    private IMappingSpecification specification;

    public ValidationHelper(IMappingSpecification specification) {
        this.specification = specification;
    }

    public void validate(InfomodelData data) throws ValidationProblem {
        for (ModelProperty fbProperty : this.specification.getInfoModel().getFunctionblocks()) {
            FunctionblockData fbData = data.get(fbProperty.getName());
            if (fbData == null) continue;
            FunctionblockModel fbModel = this.specification.getFunctionBlock(fbProperty.getName());
            for (ModelProperty statusProperty : fbModel.getStatusProperties()) {
                this.checkProperty(fbData.getStatus(), statusProperty, fbProperty.getName() + "/status");
            }
            for (ModelProperty configProperty : fbModel.getConfigurationProperties()) {
                this.checkProperty(fbData.getConfiguration(), configProperty, fbProperty.getName() + "/configuration");
            }
        }
    }

    private void checkProperty(Map<String, Object> properties, ModelProperty property, String path) {
        if (property.isMandatory() && (!properties.containsKey(property.getName()) || properties.get(property.getName()) == null)) {
            throw new ValidationProblem("Mandatory field " + path + "/" + property.getName() + " is missing");
        }
        Object propertyValue = properties.get(property.getName());
        if (propertyValue != null) {
            if (property.getType() instanceof PrimitiveType) {
                ValidationHelper.checkPrimitiveTypeValue(path, propertyValue, property);
            } else if (property.getType() instanceof ModelId) {
                // empty if block
            }
        }
    }

    private static void checkPrimitiveTypeValue(String path, Object propertyValue, ModelProperty property) {
        PrimitiveType type = (PrimitiveType)property.getType();
        if (type == PrimitiveType.STRING && !(propertyValue instanceof String)) {
            throw new ValidationProblem("Field " + path + "/" + property.getName() + " must be of type 'String'");
        }
        if (type == PrimitiveType.BOOLEAN && !(propertyValue instanceof Boolean)) {
            throw new ValidationProblem("Field " + path + "/" + property.getName() + " must be of type 'Boolean'");
        }
        if (type == PrimitiveType.DOUBLE && !(propertyValue instanceof Double)) {
            throw new ValidationProblem("Field " + path + "/" + property.getName() + " must be of type 'Double'");
        }
        if (type == PrimitiveType.FLOAT && !(propertyValue instanceof Double)) {
            throw new ValidationProblem("Field " + path + "/" + property.getName() + " must be of type 'Float'");
        }
        if (type == PrimitiveType.INT && !ValidationHelper.isInteger(propertyValue)) {
            throw new ValidationProblem("Field " + path + "/" + property.getName() + " must be of type 'Integer'");
        }
        if (type == PrimitiveType.LONG && !ValidationHelper.isLong(propertyValue)) {
            throw new ValidationProblem("Field " + path + "/" + property.getName() + " must be of type 'Long'");
        }
        if (type == PrimitiveType.BASE64_BINARY && !(propertyValue instanceof String)) {
            throw new ValidationProblem("Field " + path + "/" + property.getName() + " must be a Base64-encoded 'String'");
        }
    }

    private static boolean isInteger(Object value) {
        try {
            Integer.parseInt(value.toString());
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private static boolean isLong(Object value) {
        try {
            Long.parseLong(value.toString());
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }
}

