/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.mapping.MappingModel;
import org.eclipse.vorto.mapping.engine.DataInputFactory;
import org.eclipse.vorto.mapping.engine.MappingEngine;
import org.eclipse.vorto.mapping.engine.normalized.InfomodelData;
import org.eclipse.vorto.mapping.engine.serializer.IMappingSerializer;
import org.eclipse.vorto.mapping.engine.serializer.MappingSpecificationSerializer;
import org.eclipse.vorto.mapping.engine.spec.IMappingSpecification;
import org.eclipse.vorto.mapping.engine.spec.MappingSpecification;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.api.content.Infomodel;
import org.eclipse.vorto.repository.api.content.ModelContent;
import org.eclipse.vorto.repository.api.content.ModelProperty;
import org.eclipse.vorto.repository.api.content.Stereotype;
import org.eclipse.vorto.repository.api.exception.ModelNotFoundException;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.core.IUserContext;
import org.eclipse.vorto.repository.core.ModelAlreadyExistsException;
import org.eclipse.vorto.repository.core.impl.UserContext;
import org.eclipse.vorto.repository.web.AbstractRepositoryController;
import org.eclipse.vorto.repository.web.api.v1.ModelController;
import org.eclipse.vorto.repository.web.core.ModelDtoFactory;
import org.eclipse.vorto.repository.web.core.dto.mapping.TestMappingRequest;
import org.eclipse.vorto.repository.web.core.dto.mapping.TestMappingResponse;
import org.eclipse.vorto.repository.web.core.validation.ValidationHelper;
import org.eclipse.vorto.repository.web.core.validation.ValidationProblem;
import org.eclipse.vorto.repository.workflow.IWorkflowService;
import org.eclipse.vorto.repository.workflow.WorkflowException;
import org.eclipse.vorto.utilities.reader.IModelWorkspace;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/mappings"})
public class PayloadMappingController
extends AbstractRepositoryController {
    @Autowired
    private ModelController modelController;
    @Autowired
    private IModelRepository repository;
    @Autowired
    private IWorkflowService workflowService;
    private static Logger logger = Logger.getLogger(PayloadMappingController.class);
    private static final String ATTACHMENT_FILENAME = "attachment; filename = ";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String CONTENT_DISPOSITION = "content-disposition";

    @RequestMapping(value={"/{modelId:.+}/{targetPlatform:.+}"}, method={RequestMethod.POST})
    @PreAuthorize(value="isAuthenticated()")
    public Map<String, Object> createMappingSpecification(@PathVariable String modelId, @PathVariable String targetPlatform) throws Exception {
        logger.info((Object)("Creating Mapping Specification for " + modelId + " using key " + targetPlatform));
        if (!this.repository.getMappingModelsForTargetPlatform(ModelId.fromPrettyFormat((String)modelId), targetPlatform).isEmpty()) {
            throw new ModelAlreadyExistsException();
        }
        ModelContent modelContent = this.modelController.getModelContent(modelId);
        MappingSpecification spec = new MappingSpecification();
        spec.setInfoModel((Infomodel)modelContent.getModels().get(modelContent.getRoot()));
        for (ModelProperty property : spec.getInfoModel().getFunctionblocks()) {
            spec.getProperties().put(property.getName(), (org.eclipse.vorto.repository.api.content.FunctionblockModel)modelContent.getModels().get(property.getType()));
        }
        ModelId createdId = this.saveMappingSpecification(spec, modelId, targetPlatform);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("mappingId", createdId.getPrettyFormat());
        response.put("spec", spec);
        return response;
    }

    @RequestMapping(value={"/{modelId:.+}/{targetPlatform:.+}"}, method={RequestMethod.GET})
    public IMappingSpecification getMappingSpecification(@PathVariable String modelId, @PathVariable String targetPlatform) throws Exception {
        ModelContent infoModelContent = this.modelController.getModelContentForTargetPlatform(modelId, targetPlatform);
        Infomodel infomodel = (Infomodel)infoModelContent.getModels().get(infoModelContent.getRoot());
        if (infomodel == null) {
            ModelContent infomodelContent = this.modelController.getModelContent(modelId);
            infomodel = (Infomodel)infomodelContent.getModels().get(infomodelContent.getRoot());
        }
        MappingSpecification specification = new MappingSpecification();
        specification.setInfoModel(infomodel);
        for (ModelProperty fbProperty : infomodel.getFunctionblocks()) {
            ModelId fbModelId = (ModelId)fbProperty.getType();
            ModelId mappingId = fbProperty.getMappingReference();
            org.eclipse.vorto.repository.api.content.FunctionblockModel fbm = null;
            if (mappingId != null) {
                fbm = this.getModelContentByModelAndMappingId(fbModelId.getPrettyFormat(), mappingId.getPrettyFormat());
            } else {
                ModelContent fbmContent = this.modelController.getModelContent(fbModelId.getPrettyFormat());
                fbm = (org.eclipse.vorto.repository.api.content.FunctionblockModel)fbmContent.getModels().get(fbmContent.getRoot());
            }
            specification.getProperties().put(fbProperty.getName(), this.initEmptyProperties(fbm));
        }
        return specification;
    }

    public org.eclipse.vorto.repository.api.content.FunctionblockModel getModelContentByModelAndMappingId(@PathVariable String modelId, @PathVariable String mappingId) {
        ModelInfo vortoModelInfo = this.repository.getById(ModelId.fromPrettyFormat((String)modelId));
        ModelInfo mappingModelInfo = this.repository.getById(ModelId.fromPrettyFormat((String)mappingId));
        if (vortoModelInfo == null) {
            throw new ModelNotFoundException("Could not find vorto model with ID: " + modelId);
        }
        if (mappingModelInfo == null) {
            throw new ModelNotFoundException("Could not find mapping with ID: " + mappingId);
        }
        byte[] mappingContentZip = this.createZipWithAllDependencies(mappingModelInfo.getId());
        IModelWorkspace mappingWorkspace = IModelWorkspace.newReader().addZip(new ZipInputStream(new ByteArrayInputStream(mappingContentZip))).read();
        FunctionblockModel fbm = (FunctionblockModel)mappingWorkspace.get().stream().filter(model -> model instanceof FunctionblockModel).findFirst().get();
        return ModelDtoFactory.createResource(fbm, Optional.of((MappingModel)mappingWorkspace.get().stream().filter(model -> model instanceof MappingModel).findFirst().get()));
    }

    private byte[] createZipWithAllDependencies(ModelId modelId) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        try {
            this.addModelToZip(zos, modelId);
            zos.close();
            baos.close();
            return baos.toByteArray();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private org.eclipse.vorto.repository.api.content.FunctionblockModel initEmptyProperties(org.eclipse.vorto.repository.api.content.FunctionblockModel fbm) {
        fbm.getStatusProperties().stream().filter(p -> !p.getStereotype("source").isPresent()).forEach(p -> p.addStereotype(Stereotype.createWithXpath((String)"")));
        fbm.getConfigurationProperties().stream().filter(p -> !p.getStereotype("source").isPresent()).forEach(p -> p.addStereotype(Stereotype.createWithXpath((String)"")));
        this.unescapeMappingAttributesForStereotype(fbm, "functions");
        this.unescapeMappingAttributesForStereotype(fbm, "source");
        return fbm;
    }

    @RequestMapping(value={"/{modelId:.+}/{targetPlatform:.+}/info"}, method={RequestMethod.GET})
    public List<ModelInfo> getMappingModels(@PathVariable String modelId, @PathVariable String targetPlatform) {
        return this.repository.getMappingModelsForTargetPlatform(ModelId.fromPrettyFormat((String)modelId), targetPlatform);
    }

    private void unescapeMappingAttributesForStereotype(org.eclipse.vorto.repository.api.content.FunctionblockModel fbm, String stereotype) {
        fbm.getStatusProperties().stream().filter(p -> p.getStereotype(stereotype).isPresent()).forEach(p -> ((Stereotype)p.getStereotype(stereotype).get()).setAttributes(this.unescapeExpression(((Stereotype)p.getStereotype(stereotype).get()).getAttributes())));
    }

    private Map<String, String> unescapeExpression(Map<String, String> attributes) {
        HashMap<String, String> unescapedAttributes = new HashMap<String, String>(attributes.size());
        for (String key : attributes.keySet()) {
            String expression = attributes.get(key);
            unescapedAttributes.put(key, StringEscapeUtils.unescapeJava((String)expression));
        }
        return unescapedAttributes;
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.PUT})
    public TestMappingResponse testMapping(@RequestBody TestMappingRequest testRequest) throws Exception {
        MappingEngine engine = MappingEngine.create((IMappingSpecification)testRequest.getSpecification());
        InfomodelData mappedOutput = engine.map(DataInputFactory.getInstance().fromJson(testRequest.getSourceJson()));
        ValidationHelper validationHelper = new ValidationHelper((IMappingSpecification)testRequest.getSpecification());
        TestMappingResponse response = new TestMappingResponse();
        response.setMappedOutput(new ObjectMapper().writeValueAsString((Object)mappedOutput.getProperties()));
        try {
            validationHelper.validate(mappedOutput);
            response.setValid(true);
        }
        catch (ValidationProblem validationProblem) {
            response.setValid(false);
            response.setValidationError(validationProblem.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/{modelId:.+}/{targetPlatform:.+}"}, method={RequestMethod.PUT})
    @PreAuthorize(value="isAuthenticated()")
    public ModelId saveMappingSpecification(@RequestBody MappingSpecification mappingSpecification, @PathVariable String modelId, @PathVariable String targetPlatform) {
        logger.info((Object)("Saving mapping specification " + modelId + " with key " + targetPlatform));
        UserContext userContext = UserContext.user(SecurityContextHolder.getContext().getAuthentication().getName());
        ArrayList publishedModelIds = new ArrayList();
        MappingSpecificationSerializer.create((IMappingSpecification)mappingSpecification, (String)targetPlatform).iterator().forEachRemaining(m -> publishedModelIds.add(this.serializeAndSave((IMappingSerializer)m, userContext)));
        return (ModelId)publishedModelIds.get(publishedModelIds.size() - 1);
    }

    public ModelId serializeAndSave(IMappingSerializer m, IUserContext user) {
        ModelId createdModelId = m.getModelId();
        this.repository.save(createdModelId, m.serialize().getBytes(), createdModelId.getName() + ".mapping", user);
        try {
            this.workflowService.start(createdModelId);
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        return createdModelId;
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Successful download of mapping specification"), @ApiResponse(code=400, message="Wrong input"), @ApiResponse(code=404, message="Model not found")})
    @RequestMapping(value={"/{modelId:.+}/{targetPlatform:.+}/file"}, method={RequestMethod.GET})
    public void downloadModelById(@PathVariable String modelId, @PathVariable String targetPlatform, HttpServletResponse response) {
        Objects.requireNonNull(modelId, "modelId must not be null");
        ModelId modelID = ModelId.fromPrettyFormat((String)modelId);
        response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + modelID.getNamespace() + "_" + modelID.getName() + "_" + modelID.getVersion() + "-mappingspec.json");
        response.setContentType(APPLICATION_OCTET_STREAM);
        try {
            MappingSpecification spec = (MappingSpecification)this.getMappingSpecification(modelId, targetPlatform);
            ObjectMapper mapper = new ObjectMapper();
            IOUtils.copy((InputStream)new ByteArrayInputStream(mapper.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)spec)), (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (Exception e) {
            throw new RuntimeException("Error copying file.", e);
        }
    }

    @Override
    @ResponseStatus(value=HttpStatus.CONFLICT, reason="Mapping Specification already exists.")
    @ExceptionHandler(value={ModelAlreadyExistsException.class})
    public void ModelExists(ModelAlreadyExistsException ex) {
    }
}

