/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.api.v1;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.core.impl.UserContext;
import org.eclipse.vorto.repository.web.AbstractRepositoryController;
import org.eclipse.vorto.repository.web.core.ModelDtoFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="/search")
@RestController(value="modelSearchController")
@RequestMapping(value={"/api/v1/search/models"})
public class ModelSearchController
extends AbstractRepositoryController {
    @Value(value="${server.config.authenticatedSearchMode:#{false}}")
    private boolean authenticatedSearchMode = false;

    @ApiOperation(value="Finds models by free-text search expressions")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of search result"), @ApiResponse(code=400, message="Malformed search expression")})
    @RequestMapping(method={RequestMethod.GET})
    @PreAuthorize(value="!@modelSearchController.isAuthenticatedSearchMode() || isAuthenticated()")
    public List<ModelInfo> searchByExpression(@ApiParam(value="a free-text search expression", required=true) @RequestParam(value="expression") String expression) throws UnsupportedEncodingException {
        UserContext userContext = UserContext.user(SecurityContextHolder.getContext().getAuthentication().getName());
        List<ModelInfo> modelResources = this.modelRepository.search(URLDecoder.decode(expression, "utf-8"));
        return modelResources.stream().map(resource -> ModelDtoFactory.createDto(resource, userContext)).sorted(new Comparator<ModelInfo>(){

            @Override
            public int compare(ModelInfo o1, ModelInfo o2) {
                return o1.getCreationDate().after(o2.getCreationDate()) ? -1 : 1;
            }
        }).collect(Collectors.toList());
    }

    public boolean isAuthenticatedSearchMode() {
        return this.authenticatedSearchMode;
    }

    public void setAuthenticatedSearchMode(boolean authenticatedSearchMode) {
        this.authenticatedSearchMode = authenticatedSearchMode;
    }
}

