/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.api.v1;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.vorto.core.api.model.mapping.EntitySource;
import org.eclipse.vorto.core.api.model.mapping.EnumSource;
import org.eclipse.vorto.core.api.model.mapping.FunctionBlockSource;
import org.eclipse.vorto.core.api.model.mapping.InfomodelSource;
import org.eclipse.vorto.core.api.model.mapping.MappingModel;
import org.eclipse.vorto.core.api.model.mapping.MappingRule;
import org.eclipse.vorto.core.api.model.mapping.Source;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.api.content.ModelContent;
import org.eclipse.vorto.repository.api.exception.ModelNotFoundException;
import org.eclipse.vorto.repository.core.IUserContext;
import org.eclipse.vorto.repository.core.impl.UserContext;
import org.eclipse.vorto.repository.web.AbstractRepositoryController;
import org.eclipse.vorto.repository.web.core.ModelDtoFactory;
import org.eclipse.vorto.repository.web.core.ModelRepositoryController;
import org.eclipse.vorto.utilities.reader.IModelWorkspace;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="/models")
@RestController(value="modelRepositoryController")
@RequestMapping(value={"/api/v1/models"})
public class ModelController
extends AbstractRepositoryController {
    private static Logger logger = Logger.getLogger(ModelRepositoryController.class);

    @ApiOperation(value="Returns a model by its full qualified model ID")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of model info"), @ApiResponse(code=400, message="Wrong input"), @ApiResponse(code=404, message="Model not found"), @ApiResponse(code=403, message="Not Authorized to view model")})
    @PreAuthorize(value="!@modelSearchController.isAuthenticatedSearchMode() || isAuthenticated() || hasPermission(T(org.eclipse.vorto.repository.api.ModelId).fromPrettyFormat(#modelId),'model:get')")
    @RequestMapping(value={"/{modelId:.+}"}, method={RequestMethod.GET})
    public ModelInfo getModelInfo(@ApiParam(value="The modelId of vorto model, e.g. com.mycompany:Car:1.0.0", required=true) @PathVariable String modelId) {
        Objects.requireNonNull(modelId, "modelId must not be null");
        logger.info((Object)("getModelInfo: [" + modelId + "]"));
        ModelInfo resource = this.modelRepository.getById(ModelId.fromPrettyFormat((String)modelId));
        if (resource == null) {
            throw new ModelNotFoundException("Model does not exist", null);
        }
        return ModelDtoFactory.createDto(resource, (IUserContext)UserContext.user(SecurityContextHolder.getContext().getAuthentication().getName()));
    }

    @ApiOperation(value="Returns the complete model content")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of model content"), @ApiResponse(code=400, message="Wrong input"), @ApiResponse(code=404, message="Model not found")})
    @PreAuthorize(value="!@modelSearchController.isAuthenticatedSearchMode() || isAuthenticated() || hasPermission(T(org.eclipse.vorto.repository.api.ModelId).fromPrettyFormat(#modelId),'model:get')")
    @RequestMapping(value={"/{modelId:.+}/content"}, method={RequestMethod.GET})
    public ModelContent getModelContent(@ApiParam(value="The modelId of vorto model, e.g. com.mycompany:Car:1.0.0", required=true) @PathVariable String modelId) {
        ModelId modelID = ModelId.fromPrettyFormat((String)modelId);
        if (this.modelRepository.getById(modelID) == null) {
            throw new ModelNotFoundException("Model does not exist", null);
        }
        byte[] modelContent = this.createZipWithAllDependencies(modelID);
        IModelWorkspace workspace = IModelWorkspace.newReader().addZip(new ZipInputStream(new ByteArrayInputStream(modelContent))).read();
        ModelContent result = new ModelContent();
        result.setRoot(modelID);
        workspace.get().stream().forEach(model -> result.getModels().put(new ModelId(model.getName(), model.getNamespace(), model.getVersion()), ModelDtoFactory.createResource(model, Optional.empty())));
        return result;
    }

    @ApiOperation(value="Returns the complete model content including target platform specific attributes")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of model content"), @ApiResponse(code=400, message="Wrong input"), @ApiResponse(code=404, message="Model not found")})
    @PreAuthorize(value="!@modelSearchController.isAuthenticatedSearchMode() || isAuthenticated() || hasPermission(T(org.eclipse.vorto.repository.api.ModelId).fromPrettyFormat(#modelId),'model:get')")
    @RequestMapping(value={"/{modelId:.+}/content/{targetplatformKey}"}, method={RequestMethod.GET})
    public ModelContent getModelContentForTargetPlatform(@ApiParam(value="The modelId of vorto model, e.g. com.mycompany:Car:1.0.0", required=true) @PathVariable String modelId, @ApiParam(value="The key of the targetplatform, e.g. lwm2m", required=true) @PathVariable String targetplatformKey) {
        ModelId modelID = ModelId.fromPrettyFormat((String)modelId);
        List<ModelInfo> mappingResource = this.modelRepository.getMappingModelsForTargetPlatform(modelID, targetplatformKey);
        if (!mappingResource.isEmpty()) {
            byte[] mappingContentZip = this.createZipWithAllDependencies(mappingResource.get(0).getId());
            IModelWorkspace mappingWorkspace = IModelWorkspace.newReader().addZip(new ZipInputStream(new ByteArrayInputStream(mappingContentZip))).read();
            ModelContent result = new ModelContent();
            result.setRoot(modelID);
            mappingWorkspace.get().stream().forEach(model -> {
                Optional<Model> mappingModel;
                if (!(model instanceof MappingModel) && (mappingModel = mappingWorkspace.get().stream().filter(p -> p instanceof MappingModel).filter(p -> this.isMappingForModel((MappingModel)p, (Model)model)).findFirst()).isPresent()) {
                    result.getModels().put(new ModelId(model.getName(), model.getNamespace(), model.getVersion()), ModelDtoFactory.createResource(model, Optional.of((MappingModel)mappingModel.get())));
                }
            });
            return result;
        }
        throw new ModelNotFoundException("Content for provided target platform key does not exist", null);
    }

    private boolean isMappingForModel(MappingModel p, Model model) {
        if (p.getRules().isEmpty() || ((MappingRule)p.getRules().get(0)).getSources().isEmpty()) {
            return false;
        }
        Source mappingSource = (Source)((MappingRule)p.getRules().get(0)).getSources().get(0);
        if (mappingSource instanceof InfomodelSource) {
            return EcoreUtil.equals((EObject)((InfomodelSource)mappingSource).getModel(), (EObject)model);
        }
        if (mappingSource instanceof FunctionBlockSource) {
            return EcoreUtil.equals((EObject)((FunctionBlockSource)mappingSource).getModel(), (EObject)model);
        }
        if (mappingSource instanceof EntitySource) {
            return EcoreUtil.equals((EObject)((EntitySource)mappingSource).getModel(), (EObject)model);
        }
        if (mappingSource instanceof EnumSource) {
            return EcoreUtil.equals((EObject)((EnumSource)mappingSource).getModel(), (EObject)model);
        }
        return false;
    }

    private byte[] createZipWithAllDependencies(ModelId modelId) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        try {
            this.addModelToZip(zos, modelId);
            zos.close();
            baos.close();
            return baos.toByteArray();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @ApiOperation(value="Downloads the model file")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful download of model file"), @ApiResponse(code=400, message="Wrong input"), @ApiResponse(code=404, message="Model not found")})
    @PreAuthorize(value="!@modelSearchController.isAuthenticatedSearchMode() || isAuthenticated() || hasPermission(T(org.eclipse.vorto.repository.api.ModelId).fromPrettyFormat(#modelId),'model:get')")
    @RequestMapping(value={"/{modelId:.+}/file"}, method={RequestMethod.GET})
    public void downloadModelById(@ApiParam(value="The modelId of vorto model, e.g. com.mycompany:Car:1.0.0", required=true) @PathVariable String modelId, @ApiParam(value="Set true if dependencies shall be included", required=false) @RequestParam(value="includeDependencies", required=false) boolean includeDependencies, HttpServletResponse response) {
        Objects.requireNonNull(modelId, "modelId must not be null");
        ModelId modelID = ModelId.fromPrettyFormat((String)modelId);
        logger.info((Object)("Download of Model file : [" + modelID.toString() + "]"));
        if (includeDependencies) {
            byte[] zipContent = this.createZipWithAllDependencies(modelID);
            response.setHeader("content-disposition", "attachment; filename = " + modelID.getNamespace() + "_" + modelID.getName() + "_" + modelID.getVersion() + ".zip");
            response.setContentType("application/octet-stream");
            try {
                IOUtils.copy((InputStream)new ByteArrayInputStream(zipContent), (OutputStream)response.getOutputStream());
                response.flushBuffer();
            }
            catch (IOException e) {
                throw new RuntimeException("Error copying file.", e);
            }
        } else {
            this.createSingleModelContent(modelID, response);
        }
    }
}

