/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.api.v1;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.attachment.Attachment;
import org.eclipse.vorto.repository.api.attachment.Tag;
import org.eclipse.vorto.repository.api.exception.ModelNotFoundException;
import org.eclipse.vorto.repository.core.AttachmentException;
import org.eclipse.vorto.repository.core.FatalModelRepositoryException;
import org.eclipse.vorto.repository.core.FileContent;
import org.eclipse.vorto.repository.core.impl.UserContext;
import org.eclipse.vorto.repository.web.AbstractRepositoryController;
import org.eclipse.vorto.repository.web.api.v1.dto.AttachResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(value="/attachments")
@RestController
@RequestMapping(value={"/api/v1/attachments"})
public class AttachmentController
extends AbstractRepositoryController {
    private static final String ATTACHMENT_FILENAME = "attachment; filename = ";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String CONTENT_DISPOSITION = "content-disposition";
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    @ApiOperation(value="Upload a file to be attached to a model")
    @RequestMapping(method={RequestMethod.PUT}, value={"/{modelId:.+}"}, produces={"application/json"})
    @PreAuthorize(value="isAuthenticated() && (hasRole('ROLE_ADMIN') or hasPermission(T(org.eclipse.vorto.repository.api.ModelId).fromPrettyFormat(#modelId),'model:owner'))")
    public AttachResult attach(@ApiParam(value="The ID of the vorto model in namespace.name:version format, e.g. com.mycompany:MagneticSensor:1.0.0", required=true) @PathVariable String modelId, @ApiParam(value="The file to be uploaded as attachmment", required=true) @RequestParam(value="file") MultipartFile file) {
        ModelId modelID = ModelId.fromPrettyFormat((String)modelId);
        try {
            String fileName = URLDecoder.decode(file.getOriginalFilename(), "UTF-8");
            this.modelRepository.attachFile(modelID, new FileContent(fileName, file.getBytes(), file.getSize()), this.getUserContext(), this.guessTagsFromFileExtension(fileName));
            return AttachResult.success(modelID, fileName);
        }
        catch (IOException | AttachmentException | FatalModelRepositoryException e) {
            return AttachResult.fail(modelID, file.getOriginalFilename(), e.getMessage());
        }
    }

    private Tag[] guessTagsFromFileExtension(String fileName) {
        String _name = fileName.toLowerCase();
        if (_name.endsWith(".jpg") || _name.endsWith(".png")) {
            return new Tag[]{Attachment.TAG_IMAGE};
        }
        if (_name.endsWith(".doc") || _name.endsWith(".pdf") || _name.endsWith(".txt")) {
            return new Tag[]{Attachment.TAG_DOCUMENTATION};
        }
        return new Tag[0];
    }

    @ApiOperation(value="Get the list of file attachments for a model")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved list of attachments"), @ApiResponse(code=404, message="The resource could not be found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/{modelId:.+}"}, produces={"application/json"})
    public List<Attachment> getAttachments(@ApiParam(value="The ID of the vorto model in namespace.name:version format, e.g. com.mycompany:MagneticSensor:1.0.0", required=true) @PathVariable String modelId) {
        ModelId modelID = ModelId.fromPrettyFormat((String)modelId);
        try {
            return this.modelRepository.getAttachments(modelID);
        }
        catch (FatalModelRepositoryException e) {
            return Collections.emptyList();
        }
    }

    @ApiOperation(value="Get a specific file attachment for a model")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved the attachment"), @ApiResponse(code=404, message="The resource could not be found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/{modelId:.+}/files/{filename:.+}"})
    public void getAttachment(@ApiParam(value="The ID of the vorto model in namespace.name:version format, e.g. com.mycompany:MagneticSensor:1.0.0", required=true) @PathVariable String modelId, @ApiParam(value="The name of the attached file that you want to retrieve", required=true) @PathVariable String filename, HttpServletResponse response) {
        ModelId modelID = ModelId.fromPrettyFormat((String)modelId);
        try {
            String fileName = URLDecoder.decode(filename, "UTF-8");
            Optional<FileContent> content = this.modelRepository.getAttachmentContent(modelID, fileName);
            if (!content.isPresent()) {
                throw new ModelNotFoundException("Could not find model");
            }
            response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + fileName);
            response.setContentType(APPLICATION_OCTET_STREAM);
            IOUtils.copy((InputStream)new ByteArrayInputStream(content.get().getContent()), (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException e) {
            this.LOGGER.error("Cannot get model attachment:", (Throwable)e);
        }
    }

    @ApiOperation(value="Delete a file attachment for a model")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully deleted the attachment"), @ApiResponse(code=404, message="The resource could not be found")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/{modelId:.+}/files/{filename:.+}"})
    @PreAuthorize(value="isAuthenticated() && (hasRole('ROLE_ADMIN') or hasPermission(T(org.eclipse.vorto.repository.api.ModelId).fromPrettyFormat(#modelId),'model:owner'))")
    public ResponseEntity<Void> deleteAttachment(@ApiParam(value="The ID of the vorto model in namespace.name:version format, e.g. com.mycompany:MagneticSensor:1.0.0", required=true) @PathVariable String modelId, @ApiParam(value="The name of the attached file that you want to delete", required=true) @PathVariable String filename) {
        ModelId modelIdObject = ModelId.fromPrettyFormat((String)modelId);
        try {
            String fileName = URLDecoder.decode(filename, "UTF-8");
            if (!this.modelRepository.deleteAttachment(modelIdObject, fileName)) {
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (UnsupportedEncodingException e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }

    private UserContext getUserContext() {
        return UserContext.user(SecurityContextHolder.getContext().getAuthentication().getName());
    }
}

