/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.sso.oauth.strategy;

import java.security.PublicKey;
import java.security.Signature;
import java.util.Base64;
import java.util.Objects;
import org.eclipse.vorto.repository.sso.oauth.JwtToken;

public class VerificationHelper {
    public static boolean verifyJwtToken(PublicKey publicKey, JwtToken token) {
        Objects.requireNonNull(publicKey, "No public key.");
        Objects.requireNonNull(token.getHeaderAndPayload(), "No payload.");
        Objects.requireNonNull(token.getSignature(), "No signature.");
        try {
            Signature publicSignature = Signature.getInstance("SHA256withRSA");
            publicSignature.initVerify(publicKey);
            publicSignature.update(token.getHeaderAndPayload().getBytes());
            byte[] decodedSignature = Base64.getUrlDecoder().decode(token.getSignature().getBytes());
            return publicSignature.verify(decodedSignature);
        }
        catch (Exception e) {
            return false;
        }
    }
}

