/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.backup.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.AccessDeniedException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.eclipse.vorto.repository.backup.IModelBackupService;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.modeshape.jcr.api.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultModelBackupService
implements IModelBackupService {
    @Autowired
    private javax.jcr.Session session;
    @Autowired
    private IModelRepository modelRepository;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    public final String EXCEPTION_MESSAGE_CURRENT_CONTENT = "Not able to create a backup of the current content";
    public final String EXCEPTION_MESSAGE_RESTORABLE_CONTENT = "Not able to restore the imported backup";

    @Override
    public byte[] backup() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ((Session)this.session).exportDocumentView("/", (OutputStream)baos, false, false);
        baos.close();
        return baos.toByteArray();
    }

    @Override
    public void restore(byte[] restorableContent) throws Exception {
        byte[] currentContent = this.backup();
        try {
            this.LOGGER.info("attempting to import backup of current content");
            this.doRestore(currentContent);
        }
        catch (Exception invalidCurrentContent) {
            throw new Exception(this.EXCEPTION_MESSAGE_CURRENT_CONTENT, invalidCurrentContent);
        }
        this.removeAll();
        try {
            this.LOGGER.info("attempting to import imported backup");
            this.doRestore(restorableContent);
        }
        catch (Exception invalidContent) {
            this.doRestore(currentContent);
            throw new Exception(this.EXCEPTION_MESSAGE_RESTORABLE_CONTENT, invalidContent);
        }
    }

    private void doRestore(byte[] backup) throws AccessDeniedException, VersionException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, LockException, IOException, RepositoryException {
        ((Session)this.session).getWorkspace().importXML("/", (InputStream)new ByteArrayInputStream(backup), 2);
        this.LOGGER.info("created backup succesfully");
    }

    public javax.jcr.Session getSession() {
        return this.session;
    }

    public void setSession(javax.jcr.Session session) {
        this.session = session;
    }

    public IModelRepository getModelRepository() {
        return this.modelRepository;
    }

    public void setModelRepository(IModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    private void removeAll() throws Exception {
        NodeIterator iter = ((Session)this.session).getRootNode().getNodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (node.getName().equals("jcr:system")) continue;
            ((Session)this.session).removeItem(node.getPath());
        }
        ((Session)this.session).save();
    }
}

