/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.comment;

import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.comment.Comment;
import org.eclipse.vorto.repository.comment.ICommentService;
import org.eclipse.vorto.repository.core.IUserContext;
import org.eclipse.vorto.repository.core.impl.UserContext;
import org.eclipse.vorto.repository.web.core.ModelDtoFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/comments"})
public class CommentController {
    @Autowired
    private ICommentService commentService;

    @RequestMapping(method={RequestMethod.GET}, value={"/{modelId:.+}"}, produces={"application/json"})
    public List<Comment> getCommentsforModelId(@ApiParam(value="modelId", required=true) @PathVariable String modelId) {
        ModelId modelID = ModelId.fromPrettyFormat((String)modelId);
        return this.commentService.getCommentsforModelId(modelID).stream().map(comment -> ModelDtoFactory.createDto(comment, (IUserContext)UserContext.user(SecurityContextHolder.getContext().getAuthentication().getName()))).collect(Collectors.toList());
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"})
    @PreAuthorize(value="isAuthenticated()")
    public ResponseEntity<Void> addCommentToModel(@RequestBody @Valid Comment comment) throws Exception {
        this.commentService.createComment(comment);
        return new ResponseEntity(HttpStatus.CREATED);
    }
}

