/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.account;

import io.swagger.annotations.ApiParam;
import java.security.Principal;
import org.eclipse.vorto.repository.account.IUserAccountService;
import org.eclipse.vorto.repository.account.UserUtils;
import org.eclipse.vorto.repository.account.impl.IUserRepository;
import org.eclipse.vorto.repository.account.impl.User;
import org.eclipse.vorto.repository.upgrade.IUpgradeService;
import org.eclipse.vorto.repository.web.account.dto.UserDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/users"})
public class UserController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IUserRepository userRepository;
    @Autowired
    private IUserAccountService accountService;
    @Autowired
    private IUpgradeService updateService;

    @RequestMapping(method={RequestMethod.GET}, value={"/{username:.+}"})
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or #username == authentication.name")
    public ResponseEntity<UserDto> getUser(@ApiParam(value="Username", required=true) @PathVariable String username) {
        this.LOGGER.debug("User {} - {} ", (Object)username, (Object)this.userRepository.findByUsername(username));
        return new ResponseEntity((Object)UserDto.fromUser(this.userRepository.findByUsername(username)), HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"})
    public ResponseEntity<Boolean> createUser(Principal user) {
        OAuth2Authentication oauth2User = (OAuth2Authentication)user;
        if (this.userRepository.findByUsername(oauth2User.getName()) != null) {
            return new ResponseEntity((Object)false, HttpStatus.CREATED);
        }
        this.LOGGER.info("User: '{}' accepted the terms and conditions.", (Object)oauth2User.getName());
        User createdUser = this.accountService.create(oauth2User.getName());
        UserUtils.refreshSpringSecurityUser(createdUser);
        return new ResponseEntity((Object)true, HttpStatus.CREATED);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{username:.+}/updateTask"})
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or #username == authentication.name")
    public ResponseEntity<Boolean> updateUser(Principal user, @ApiParam(value="Username", required=true) @PathVariable String username) {
        User userAccount = this.userRepository.findByUsername(username);
        if (userAccount == null) {
            return new ResponseEntity((Object)true, HttpStatus.BAD_REQUEST);
        }
        this.updateService.installUserUpgrade(userAccount, () -> user);
        return new ResponseEntity((Object)true, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{username:.+}"}, method={RequestMethod.DELETE})
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#username,'user:delete')")
    public ResponseEntity<Void> deleteAccount(@PathVariable(value="username") String username) {
        this.accountService.delete(username);
        return new ResponseEntity(HttpStatus.OK);
    }
}

