/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.vorto.repository.account.IUserAccountService;
import org.eclipse.vorto.repository.account.impl.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HomeController {
    private static final String LOGIN_TYPE = "loginType";
    private static final String LOGOUT_URL = "/logout";
    @Value(value="${github.oauth2.enabled}")
    private boolean githubEnabled;
    @Value(value="${eidp.oauth2.enabled}")
    private boolean eidpEnabled;
    @Value(value="${server.config.authenticatedSearchMode:#{false}}")
    private boolean authenticatedSearchMode = false;
    @Value(value="${eidp.oauth2.resource.logoutEndpointUrl:#{null}}")
    private String logoutEndpointUrl;
    @Value(value="${eidp.oauth2.resource.logoutRedirectUrl:#{null}}")
    private String logoutRedirectUrl;
    @Value(value="#{servletContext.contextPath}")
    private String servletContextPath;
    @Value(value="${repo.attachment.allowed.fileSize}")
    private String attachmentAllowedSize;
    @Autowired
    private OAuth2ClientContext oauth2ClientContext;
    @Value(value="${server.config.updateDate:#{'2000-01-01 12:00:00'}}")
    private String updateDate;
    @Value(value="${server.config.supportEmail:#{null}}")
    private String supportEmail;
    @Autowired
    private IUserAccountService accountService;

    @ApiOperation(value="Returns the currently logged in User")
    @ApiResponses(value={@ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=200, message="OK")})
    @RequestMapping(value={"/user", "/me"}, method={RequestMethod.GET})
    public ResponseEntity<Map<String, String>> getUser(Principal user, HttpServletRequest request) throws ParseException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (user == null) {
            return new ResponseEntity(map, HttpStatus.UNAUTHORIZED);
        }
        OAuth2Authentication oauth2User = (OAuth2Authentication)user;
        oauth2User.getAuthorities().stream().findFirst().ifPresent(role -> map.put("role", role.getAuthority()));
        User userAccount = this.accountService.getUser(oauth2User.getName());
        Date updateCutoff = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(this.updateDate);
        map.put("name", oauth2User.getName());
        map.put("displayName", this.getDisplayName(oauth2User));
        map.put("isRegistered", Boolean.toString(userAccount != null));
        map.put("needUpdate", Boolean.toString(this.needUpdate(userAccount, updateCutoff)));
        Map userDetails = (Map)oauth2User.getUserAuthentication().getDetails();
        map.put(LOGIN_TYPE, (String)userDetails.get(LOGIN_TYPE));
        return new ResponseEntity(map, HttpStatus.OK);
    }

    private boolean needUpdate(User user, Date updateCutoff) {
        return user != null && user.getLastUpdated().before(updateCutoff) && new Date().after(updateCutoff);
    }

    private String getDisplayName(OAuth2Authentication oauth2User) {
        UsernamePasswordAuthenticationToken userAuth = (UsernamePasswordAuthenticationToken)oauth2User.getUserAuthentication();
        Map userDetailsMap = (Map)userAuth.getDetails();
        String login = (String)userDetailsMap.get("login");
        if (login != null) {
            return login;
        }
        String email = (String)userDetailsMap.get("email");
        if (email != null) {
            return email.split("@")[0];
        }
        return oauth2User.getName();
    }

    @RequestMapping(value={"/context"}, method={RequestMethod.GET})
    public Map<String, Object> globalContext(HttpServletRequest request) {
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>();
        context.put("githubEnabled", this.githubEnabled);
        context.put("eidpEnabled", this.eidpEnabled);
        context.put("authenticatedSearchMode", this.authenticatedSearchMode);
        context.put("logOutUrl", this.getLogoutEndpointUrl(this.getBaseUrl(request)));
        context.put("attachmentAllowedSize", this.attachmentAllowedSize);
        context.put("supportEmail", this.supportEmail);
        return context;
    }

    public String getBaseUrl(HttpServletRequest request) {
        if (request.getRequestURI().equals("/") || request.getRequestURI().equals("")) {
            return request.getRequestURL().toString();
        }
        return request.getRequestURL().toString().replace(request.getRequestURI(), "");
    }

    private String getLogoutEndpointUrl(String baseUrl) {
        if (this.eidpEnabled) {
            String idToken = "";
            if (SecurityContextHolder.getContext().getAuthentication() instanceof OAuth2Authentication) {
                idToken = (String)this.oauth2ClientContext.getAccessToken().getAdditionalInformation().get("id_token");
            }
            return String.format("%s?id_token_hint=%s&post_logout_redirect_uri=%s", this.logoutEndpointUrl, idToken, this.logoutRedirectUrl);
        }
        return baseUrl + this.servletContextPath + LOGOUT_URL;
    }
}

