/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.sso.oauth.strategy;

import java.security.PublicKey;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.vorto.repository.account.IUserAccountService;
import org.eclipse.vorto.repository.account.Role;
import org.eclipse.vorto.repository.account.impl.User;
import org.eclipse.vorto.repository.sso.oauth.JwtToken;
import org.eclipse.vorto.repository.sso.oauth.JwtVerifyAndIdStrategy;
import org.eclipse.vorto.repository.sso.oauth.strategy.PublicKeyHelper;
import org.eclipse.vorto.repository.sso.oauth.strategy.VerificationHelper;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractVerifyAndIdStrategy
implements JwtVerifyAndIdStrategy {
    protected static final String JWT_EMAIL = "email";
    private static final String JWT_EXPIRY = "exp";
    protected static final String JWT_NAME = "name";
    protected static final String JWT_SUB = "sub";
    private static final String KEY_ID = "kid";
    protected static final String ROLE_ADMIN = "ROLE_ADMIN";
    protected static final String ROLE_USER = "ROLE_USER";
    private String ciamClientId;
    private PublicKeyHelper publicKeyHelper;
    private Map<String, PublicKey> publicKeys = null;
    private String publicKeyUri = null;
    private IUserAccountService userAccountService;

    public AbstractVerifyAndIdStrategy(RestTemplate restTemplate, String publicKeyUri, IUserAccountService userAccountService, String clientId) {
        this.publicKeyHelper = PublicKeyHelper.instance(restTemplate);
        this.publicKeyUri = Objects.requireNonNull(publicKeyUri);
        this.ciamClientId = Objects.requireNonNull(clientId);
        this.userAccountService = Objects.requireNonNull(userAccountService);
    }

    @Override
    public OAuth2Authentication createAuthentication(JwtToken accessToken) {
        OAuth2Request request = new OAuth2Request(null, this.ciamClientId, null, true, null, null, null, null, null);
        Map<String, Object> map = accessToken.getPayloadMap();
        Optional<String> email = Optional.ofNullable((String)map.get(JWT_EMAIL));
        Optional<String> name = Optional.ofNullable((String)map.get(JWT_NAME)).map(str -> str.split("@")[0]);
        String userId = this.getUserId(map).orElseThrow(() -> new InvalidTokenException("Cannot generate a userId from your provided token. Maybe 'sub' or 'client_id' is not present in JWT token?"));
        User user = this.userAccountService.getUser(userId);
        UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken((Object)name.orElse(userId), (Object)"N/A", (Collection)AuthorityUtils.commaSeparatedStringToAuthorityList((String)(user.getRole() == Role.USER ? ROLE_USER : ROLE_ADMIN)));
        HashMap<String, String> detailsMap = new HashMap<String, String>();
        detailsMap.put(JWT_SUB, userId);
        detailsMap.put(JWT_NAME, name.orElse(userId));
        detailsMap.put(JWT_EMAIL, email.orElse(null));
        authToken.setDetails(detailsMap);
        return new OAuth2Authentication(request, (Authentication)authToken);
    }

    protected abstract Optional<String> getUserId(Map<String, Object> var1);

    @Override
    public boolean verify(JwtToken jwtToken) {
        String keyId;
        if (this.publicKeys == null || this.publicKeys.isEmpty()) {
            this.publicKeys = this.publicKeyHelper.getPublicKey(this.publicKeyUri);
        }
        if ((keyId = (String)jwtToken.getHeaderMap().get(KEY_ID)) == null) {
            throw new InvalidTokenException(String.format("AccessToken '%s' doesn't have a kid in header", jwtToken.getJwtToken()));
        }
        PublicKey publicKey = this.publicKeys.get(keyId);
        if (publicKey == null) {
            throw new InvalidTokenException(String.format("There are no public keys with kid '%s'", keyId));
        }
        if (VerificationHelper.verifyJwtToken(publicKey, jwtToken)) {
            Optional<Instant> expirationDate;
            Map<String, Object> payloadMap = jwtToken.getPayloadMap();
            if (payloadMap.containsKey(JWT_EXPIRY) && (expirationDate = Optional.ofNullable(Double.valueOf((Double)payloadMap.get(JWT_EXPIRY)).longValue()).map(Instant::ofEpochSecond)).isPresent() && expirationDate.get().isBefore(Instant.now())) {
                return false;
            }
            String userId = this.getUserId(payloadMap).orElseThrow(() -> new InvalidTokenException("Cannot generate a userId from your provided token. Maybe 'sub' or 'client_id' is not present in JWT token?"));
            return this.userAccountService.exists(userId);
        }
        return false;
    }
}

