/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.sso.oauth;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.eclipse.vorto.repository.account.IUserAccountService;
import org.eclipse.vorto.repository.sso.oauth.JwtToken;
import org.eclipse.vorto.repository.sso.oauth.JwtVerifyAndIdStrategy;
import org.eclipse.vorto.repository.sso.oauth.strategy.CiamUserStrategy;
import org.eclipse.vorto.repository.sso.oauth.strategy.KeycloakUserStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component(value="jwtTokenUserInfoServices")
public class JwtTokenUserInfoServices
extends UserInfoTokenServices {
    private static final String ISSUER = "iss";
    @Value(value="${eidp.oauth2.client.clientId: #{null}}")
    private String ciamClientId;
    @Value(value="${oauth2.verification.eidp.issuer: #{null}}")
    private String ciamJwtIssuer;
    @Value(value="${oauth2.verification.eidp.publicKeyUri: #{null}}")
    private String ciamPublicKeyUri;
    @Value(value="${oauth2.verification.keycloak.issuer: #{null}}")
    private String keycloakJwtIssuer;
    @Value(value="${oauth2.verification.keycloak.publicKeyUri: #{null}}")
    private String keycloakPublicKeyUri;
    @Autowired
    private IUserAccountService userAccountService;
    private Map<String, JwtVerifyAndIdStrategy> verifyAndIdStrategies = new HashMap<String, JwtVerifyAndIdStrategy>();

    public JwtTokenUserInfoServices() {
        super(null, null);
    }

    private Optional<JwtVerifyAndIdStrategy> getStrategy(JwtToken jwtToken) {
        String issuer = (String)jwtToken.getPayloadMap().get(ISSUER);
        if (issuer != null) {
            return Optional.ofNullable(this.verifyAndIdStrategies.get(issuer));
        }
        return Optional.empty();
    }

    @PostConstruct
    public void init() {
        if (this.ciamJwtIssuer != null) {
            this.verifyAndIdStrategies.put(this.ciamJwtIssuer, new CiamUserStrategy(new RestTemplate(), this.ciamPublicKeyUri, this.userAccountService, this.ciamClientId));
        }
        if (this.keycloakJwtIssuer != null) {
            this.verifyAndIdStrategies.put(this.keycloakJwtIssuer, new KeycloakUserStrategy(new RestTemplate(), this.keycloakPublicKeyUri, this.userAccountService, this.ciamClientId));
        }
    }

    public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException, InvalidTokenException {
        JwtToken jwtToken = JwtToken.instance(accessToken).orElseThrow(() -> new InvalidTokenException("The access token '" + accessToken + "' is not a proper JWT token."));
        Optional<JwtVerifyAndIdStrategy> strategyToUse = this.getStrategy(jwtToken);
        if (strategyToUse.isPresent()) {
            JwtVerifyAndIdStrategy strategy = strategyToUse.get();
            if (strategy.verify(jwtToken)) {
                return strategy.createAuthentication(jwtToken);
            }
            throw new InvalidTokenException("The JWT token '" + accessToken + "' cannot be verified. Either it is malformed, the user isn't registered, or it has already expired.");
        }
        throw new InvalidTokenException("No strategy for authenticating the JWT token. Tokens must have 'iss' whose issuers are configured in Thingtype.");
    }

    public OAuth2AccessToken readAccessToken(String accessToken) {
        throw new UnsupportedOperationException("Not supported: read access token");
    }
}

