/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.sso.oauth;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class JwtToken {
    private String header;
    private String payload;
    private String signature;

    public static Optional<JwtToken> instance(String jwtToken) {
        Objects.requireNonNull(jwtToken);
        String[] jwtParts = jwtToken.split("\\.");
        if (jwtParts.length != 3) {
            return Optional.empty();
        }
        return Optional.of(new JwtToken(jwtParts[0], jwtParts[1], jwtParts[2]));
    }

    private JwtToken(String header, String payload, String signature) {
        this.header = header;
        this.payload = payload;
        this.signature = signature;
    }

    public String getHeader() {
        return this.header;
    }

    public String getHeaderAndPayload() {
        return this.header + "." + this.payload;
    }

    public Map<String, Object> getHeaderMap() {
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        return (Map)new Gson().fromJson(new String(Base64.getUrlDecoder().decode(this.header)), type);
    }

    public String getJwtToken() {
        return this.header + "." + this.payload + "." + this.signature;
    }

    public String getPayload() {
        return this.payload;
    }

    public Map<String, Object> getPayloadMap() {
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        return (Map)new Gson().fromJson(new String(Base64.getUrlDecoder().decode(this.payload)), type);
    }

    public String getSignature() {
        return this.signature;
    }

    public String toString() {
        return "JwtToken [header=" + this.header + ",\npayload=" + this.payload + ",\nsignature=" + this.signature + "]";
    }
}

