/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.init;

import java.util.stream.Stream;
import org.eclipse.vorto.repository.account.IUserAccountService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class AddTechnicalUserInit
implements ApplicationListener<ApplicationReadyEvent> {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IUserAccountService userAccountService;
    @Value(value="${oauth2.verification.eidp.technicalUsers:}")
    private String[] ciamTechnicalUsers;
    @Value(value="${oauth2.verification.keycloak.technicalUsers:}")
    private String[] keycloakTechnicalUsers;

    public void onApplicationEvent(ApplicationReadyEvent arg0) {
        Stream.concat(Stream.of(this.ciamTechnicalUsers), Stream.of(this.keycloakTechnicalUsers)).forEach(user -> {
            if (!this.userAccountService.exists((String)user)) {
                this.LOGGER.info("Creating technical user: {}", user);
                this.userAccountService.create((String)user);
            }
        });
    }
}

