/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.generation.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.api.ModelType;
import org.eclipse.vorto.repository.api.exception.GenerationException;
import org.eclipse.vorto.repository.api.exception.ModelNotFoundException;
import org.eclipse.vorto.repository.api.generation.GeneratedOutput;
import org.eclipse.vorto.repository.api.generation.GeneratorInfo;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.generation.IGeneratorService;
import org.eclipse.vorto.repository.generation.impl.Generator;
import org.eclipse.vorto.repository.generation.impl.IGeneratorLookupRepository;
import org.modeshape.common.collection.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class GenerationDelegateProxyService
implements IGeneratorService {
    @Autowired
    private IGeneratorLookupRepository registeredGeneratorsRepository;
    @Autowired
    private IModelRepository modelRepositoryService;
    private RestTemplate restTemplate = new RestTemplate();
    private static final Logger LOGGER = LoggerFactory.getLogger(GenerationDelegateProxyService.class);

    @Override
    public void registerGenerator(String serviceKey, String baseUrl) {
        Generator generator = this.getGenerator(serviceKey);
        if (generator == null) {
            this.registeredGeneratorsRepository.save(new Generator(serviceKey, baseUrl, "platform"));
        } else {
            generator.setBaseUrl(baseUrl);
            generator.setClassifier("platform");
            this.registeredGeneratorsRepository.save(generator);
        }
    }

    @Override
    public void unregisterGenerator(String serviceKey) {
        Generator generator = this.getGenerator(serviceKey);
        if (generator != null) {
            this.registeredGeneratorsRepository.delete(generator);
        }
    }

    @Override
    public Set<String> getRegisteredGeneratorServiceKeys() {
        HashSet<String> serviceKeys = new HashSet<String>();
        for (Generator generator : this.registeredGeneratorsRepository.findByClassifier("platform")) {
            serviceKeys.add(generator.getKey());
        }
        return Collections.unmodifiableSet(serviceKeys);
    }

    @Override
    public GeneratorInfo getGeneratorServiceInfo(String serviceKey, boolean includeConfigUI) {
        Generator generatorEntity = this.getGenerator(serviceKey);
        GeneratorInfo generatorInfo = (GeneratorInfo)this.restTemplate.getForObject(generatorEntity.getGenerationInfoUrl() + "?includeConfigUI={includeConfigUI}", GeneratorInfo.class, new Object[]{includeConfigUI});
        generatorInfo.setInfoUrl(generatorEntity.getGenerationInfoUrl());
        generatorInfo.performRating(generatorEntity.getInvocationCount());
        return generatorInfo;
    }

    @Override
    public GeneratedOutput generate(ModelId modelId, String serviceKey, Map<String, String> requestParams) {
        ModelInfo modelResource = this.modelRepositoryService.getById(modelId);
        if (modelResource == null) {
            throw new ModelNotFoundException("Model with the given ID does not exist", null);
        }
        if (modelResource.getType() == ModelType.Datatype || modelResource.getType() == ModelType.Mapping) {
            throw new GenerationException("Provided model is neither an information model nor a function block model!");
        }
        this.restTemplate.getMessageConverters().add(new ByteArrayHttpMessageConverter());
        Generator generatorEntity = this.getGenerator(serviceKey);
        if (generatorEntity == null) {
            throw new GenerationException("Generator with key " + serviceKey + " is not a registered generator");
        }
        generatorEntity.increaseInvocationCount();
        this.registeredGeneratorsRepository.save(generatorEntity);
        HttpEntity entity = this.getUserToken().map(token -> {
            HttpHeaders headers = new HttpHeaders();
            headers.add("Authorization", "Bearer " + token);
            return new HttpEntity((Object)"parameters", (MultiValueMap)headers);
        }).orElse(null);
        ResponseEntity response = this.restTemplate.exchange(generatorEntity.getGenerationEndpointUrl() + this.attachRequestParams(requestParams), HttpMethod.GET, entity, byte[].class, new Object[]{modelId.getNamespace(), modelId.getName(), modelId.getVersion()});
        return new GeneratedOutput((byte[])response.getBody(), this.extractFileNameFromHeader((ResponseEntity<byte[]>)response), response.getHeaders().getContentLength());
    }

    private Optional<String> getUserToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication instanceof OAuth2Authentication && authentication.getDetails() instanceof OAuth2AuthenticationDetails) {
            OAuth2AuthenticationDetails details = (OAuth2AuthenticationDetails)authentication.getDetails();
            return Optional.ofNullable(details.getTokenValue());
        }
        return Optional.empty();
    }

    private String attachRequestParams(Map<String, String> requestParams) {
        if (requestParams.isEmpty()) {
            return "";
        }
        StringBuilder requestUrlParams = new StringBuilder("?");
        Iterator<String> iter = requestParams.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            requestUrlParams.append(key);
            requestUrlParams.append("=");
            requestUrlParams.append(requestParams.get(key));
            if (!iter.hasNext()) continue;
            requestUrlParams.append("&");
        }
        return requestUrlParams.toString();
    }

    private String extractFileNameFromHeader(ResponseEntity<byte[]> entity) {
        List values = entity.getHeaders().get((Object)"content-disposition");
        if (values.size() > 0) {
            int indexOfFileNameStart = ((String)values.get(0)).indexOf("=");
            return ((String)values.get(0)).substring(indexOfFileNameStart + 1);
        }
        return "generated.output";
    }

    private Generator getGenerator(String serviceKey) {
        List<Generator> generators = this.registeredGeneratorsRepository.findByGeneratorKey(serviceKey);
        if (!generators.isEmpty()) {
            return generators.get(0);
        }
        return null;
    }

    @Override
    public Collection<GeneratorInfo> getMostlyUsedGenerators(int top) {
        ArrayList<Generator> topResult = new ArrayList<Generator>();
        for (Generator entity : this.registeredGeneratorsRepository.findByClassifier("platform")) {
            topResult.add(entity);
        }
        topResult.sort(new Comparator<Generator>(){

            @Override
            public int compare(Generator o1, Generator o2) {
                if (o1.getInvocationCount() > o2.getInvocationCount()) {
                    return -1;
                }
                if (o1.getInvocationCount() < o2.getInvocationCount()) {
                    return 1;
                }
                return 0;
            }
        });
        ArrayList<GeneratorInfo> result = new ArrayList<GeneratorInfo>(top);
        int counter = 0;
        for (Generator entity : topResult) {
            if (counter >= top) continue;
            try {
                result.add(this.getGeneratorServiceInfo(entity.getKey(), false));
                ++counter;
            }
            catch (Throwable t) {
                LOGGER.warn("Generator " + entity.getKey() + " appears to be offline or not deployed. Skipping...");
            }
        }
        return result;
    }
}

