/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.core.impl.resolver;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.vorto.core.api.model.mapping.MappingModel;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.api.ModelType;
import org.eclipse.vorto.repository.core.IModelIdResolver;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.core.ModelFileContent;
import org.eclipse.vorto.repository.web.core.dto.ResolveQuery;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractResolver
implements IModelIdResolver {
    @Autowired
    protected IModelRepository repository;

    @Override
    public ModelId resolve(ResolveQuery query) {
        List<ModelInfo> mappings = this.repository.search(ModelType.Mapping.name());
        Optional<ModelId> foundId = mappings.stream().filter(resource -> this.matchesServiceKey((ModelInfo)resource, query.getTargetPlatformKey())).map(r -> this.doResolve((ModelInfo)r, query)).filter(modelId -> Objects.nonNull(modelId)).findFirst();
        return foundId.isPresent() ? foundId.get() : null;
    }

    private boolean matchesServiceKey(ModelInfo resource, String targetPlatformKey) {
        ModelFileContent content = this.repository.getModelContent(resource.getId());
        return ((MappingModel)content.getModel()).getTargetPlatform().equals(targetPlatformKey);
    }

    protected abstract ModelId doResolve(ModelInfo var1, ResolveQuery var2);

    public IModelRepository getRepository() {
        return this.repository;
    }

    public void setRepository(IModelRepository repository) {
        this.repository = repository;
    }
}

