/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.core.impl;

import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jcr.Repository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.RepositoryConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JcrRepositoryFactory
implements FactoryBean<Repository> {
    private static final Logger LOG = LoggerFactory.getLogger(JcrRepositoryFactory.class);
    private static final ModeShapeEngine ENGINE = new ModeShapeEngine();
    private Repository repository;
    @Autowired
    private RepositoryConfiguration repositoryConfiguration;

    @PostConstruct
    public void start() throws Exception {
        LOG.debug("Starting Vorto Modeshape Repository");
        ENGINE.start();
        this.repository = ENGINE.deploy(this.repositoryConfiguration);
        ENGINE.startRepository(this.repositoryConfiguration.getName());
    }

    @PreDestroy
    public void stop() throws Exception {
        try {
            ENGINE.shutdown().get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.error("Error while waiting for the ModeShape engine to shutdown", (Throwable)e);
        }
    }

    public Repository getObject() throws Exception {
        return this.repository;
    }

    public Class<?> getObjectType() {
        return Repository.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

