/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.api.exception.GenerationException;
import org.eclipse.vorto.repository.api.exception.ModelNotFoundException;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.core.ModelAlreadyExistsException;
import org.eclipse.vorto.repository.core.ModelFileContent;
import org.eclipse.vorto.repository.web.core.exceptions.NotAuthorizedException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;

public abstract class AbstractRepositoryController {
    @Autowired
    protected IModelRepository modelRepository;
    protected static final String ATTACHMENT_FILENAME = "attachment; filename = ";
    protected static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    protected static final String CONTENT_DISPOSITION = "content-disposition";

    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="Model not found.")
    @ExceptionHandler(value={ModelNotFoundException.class})
    public void NotFound(ModelNotFoundException ex) {
    }

    @ResponseStatus(value=HttpStatus.CONFLICT, reason="Model already exists.")
    @ExceptionHandler(value={ModelAlreadyExistsException.class})
    public void ModelExists(ModelAlreadyExistsException ex) {
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST, reason="Wrong Input")
    @ExceptionHandler(value={IllegalArgumentException.class})
    public void WrongInput(IllegalArgumentException ex) {
    }

    @ResponseStatus(value=HttpStatus.UNAUTHORIZED, reason="Not authorized to view the model")
    @ExceptionHandler(value={NotAuthorizedException.class})
    public void unAuthorized(NotAuthorizedException ex) {
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST, reason="Error during generation.")
    @ExceptionHandler(value={GenerationException.class})
    public void GeneratorProblem(GenerationException ex) {
    }

    protected void createSingleModelContent(ModelId modelId, HttpServletResponse response) {
        ModelFileContent fileContent = this.modelRepository.getModelContent(modelId);
        byte[] modelContent = fileContent.getContent();
        if (modelContent != null && modelContent.length > 0) {
            response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + fileContent.getFileName());
            response.setContentType(APPLICATION_OCTET_STREAM);
            try {
                IOUtils.copy((InputStream)new ByteArrayInputStream(modelContent), (OutputStream)response.getOutputStream());
                response.flushBuffer();
            }
            catch (IOException e) {
                throw new RuntimeException("Error copying file.", e);
            }
        } else {
            throw new RuntimeException("File not found.");
        }
    }

    protected void addModelToZip(ZipOutputStream zipOutputStream, ModelId modelId) throws Exception {
        ModelFileContent modelFile = this.modelRepository.getModelContent(modelId);
        ModelInfo modelResource = this.modelRepository.getById(modelId);
        try {
            ZipEntry zipEntry = new ZipEntry(modelFile.getFileName());
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(modelFile.getContent());
            zipOutputStream.closeEntry();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (ModelId reference : modelResource.getReferences()) {
            this.addModelToZip(zipOutputStream, reference);
        }
    }

    protected void sendAsZipFile(HttpServletResponse response, String fileName, List<ModelInfo> modelInfos) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        try {
            for (ModelInfo modelInfo : modelInfos) {
                this.addModelToZip(zos, modelInfo.getId());
            }
            zos.close();
            baos.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + fileName);
        response.setContentType(APPLICATION_OCTET_STREAM);
        try {
            IOUtils.copy((InputStream)new ByteArrayInputStream(baos.toByteArray()), (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException("Error copying file.", e);
        }
    }
}

