/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.upgrade.impl;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Optional;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.comment.Comment;
import org.eclipse.vorto.repository.comment.ICommentService;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.core.impl.UserContext;
import org.eclipse.vorto.repository.upgrade.AbstractUpgradeTask;
import org.eclipse.vorto.repository.upgrade.IUpgradeTask;
import org.eclipse.vorto.repository.upgrade.IUpgradeTaskCondition;
import org.eclipse.vorto.repository.upgrade.UpgradeProblem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class GdprUpgradeTask
extends AbstractUpgradeTask
implements IUpgradeTask {
    private static final Logger logger = LoggerFactory.getLogger(GdprUpgradeTask.class);
    @Value(value="${server.upgrade.gdpr:false}")
    private boolean shouldExecuteGdprUpgradeTask;
    @Autowired
    private ICommentService commentService;
    private IUpgradeTaskCondition upgradeTaskCondition = new IUpgradeTaskCondition(){

        @Override
        public boolean shouldExecuteTask() {
            return GdprUpgradeTask.this.shouldExecuteGdprUpgradeTask;
        }
    };

    public GdprUpgradeTask(@Autowired IModelRepository repository, @Autowired ICommentService commentService) {
        super(repository);
        this.commentService = commentService;
    }

    @Override
    public void doUpgrade() throws UpgradeProblem {
        List<ModelInfo> modelInfos = this.getModelRepository().search(null);
        for (ModelInfo modelInfo : modelInfos) {
            if (this.isNotEmptyAndNotHashed(modelInfo.getAuthor())) {
                logger.info("Upgrading " + modelInfo.toString() + " to comply to GDPR.");
                modelInfo.setAuthor(UserContext.user(modelInfo.getAuthor()).getHashedUsername());
                this.getModelRepository().updateMeta(modelInfo);
            }
            this.upgradeComments(this.commentService.getCommentsforModelId(modelInfo.getId()));
        }
    }

    private void upgradeComments(List<Comment> commentsforModelId) {
        commentsforModelId.stream().forEach(comment -> {
            if (this.isNotEmptyAndNotHashed(comment.getAuthor())) {
                logger.info("Upgrading comment " + comment.toString() + " to comply to GDPR.");
                comment.setAuthor(UserContext.user(comment.getAuthor()).getHashedUsername());
                this.commentService.saveComment((Comment)comment);
            }
        });
    }

    private boolean isNotEmptyAndNotHashed(String author) {
        return !Strings.nullToEmpty((String)author).trim().isEmpty() && author.length() < 64;
    }

    @Override
    public Optional<IUpgradeTaskCondition> condition() {
        return Optional.of(this.upgradeTaskCondition);
    }

    public IUpgradeTaskCondition getUpgradeTaskCondition() {
        return this.upgradeTaskCondition;
    }

    public void setUpgradeTaskCondition(IUpgradeTaskCondition upgradeTaskCondition) {
        this.upgradeTaskCondition = upgradeTaskCondition;
    }

    @Override
    public String getShortDescription() {
        return "Task for hashing the model authors in compliance with GDPR.";
    }
}

