/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.importer;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.vorto.repository.account.impl.IUserRepository;
import org.eclipse.vorto.repository.account.impl.User;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.api.ModelType;
import org.eclipse.vorto.repository.api.attachment.Attachment;
import org.eclipse.vorto.repository.core.FileContent;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.core.IUserContext;
import org.eclipse.vorto.repository.core.ModelResource;
import org.eclipse.vorto.repository.core.impl.ITemporaryStorage;
import org.eclipse.vorto.repository.core.impl.StorageItem;
import org.eclipse.vorto.repository.core.impl.parser.ModelParserFactory;
import org.eclipse.vorto.repository.core.impl.utils.DependencyManager;
import org.eclipse.vorto.repository.importer.FileUpload;
import org.eclipse.vorto.repository.importer.IModelImporter;
import org.eclipse.vorto.repository.importer.ModelImporterException;
import org.eclipse.vorto.repository.importer.UploadModelResult;
import org.eclipse.vorto.repository.importer.ValidationReport;
import org.eclipse.vorto.repository.web.core.exceptions.BulkUploadException;
import org.modeshape.common.collection.Collections;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractModelImporter
implements IModelImporter {
    public static final long TTL_TEMP_STORAGE_INSECONDS = 300L;
    @Autowired
    private ITemporaryStorage uploadStorage;
    @Autowired
    private IModelRepository modelRepository;
    @Autowired
    private IUserRepository userRepository;
    private Set<String> supportedFileExtensions = new HashSet<String>();
    protected static final String EXTENSION_ZIP = ".zip";

    public AbstractModelImporter(String modelTypeFileExtension, String ... additionalExtensions) {
        if (this.handleZipUploads()) {
            this.supportedFileExtensions.add(EXTENSION_ZIP);
        }
        this.supportedFileExtensions.add(modelTypeFileExtension);
        this.supportedFileExtensions.addAll(Arrays.asList(additionalExtensions));
    }

    @Override
    public UploadModelResult upload(FileUpload fileUpload, IUserContext user) {
        if (!this.supportedFileExtensions.contains(fileUpload.getFileExtension())) {
            return new UploadModelResult(null, Arrays.asList(ValidationReport.invalid(null, "File type is invalid. Must be " + this.supportedFileExtensions)));
        }
        ArrayList<ValidationReport> reports = new ArrayList<ValidationReport>();
        if (this.handleZipUploads() && fileUpload.getFileExtension().equalsIgnoreCase(EXTENSION_ZIP)) {
            ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(fileUpload.getContent()));
            ZipEntry entry = null;
            try {
                while ((entry = zis.getNextEntry()) != null) {
                    if (entry.isDirectory() || entry.getName().substring(entry.getName().lastIndexOf("/") + 1).startsWith(".")) continue;
                    FileUpload extractedFile = FileUpload.create(entry.getName(), AbstractModelImporter.copyStream(zis, entry));
                    if (!this.getSupportedFileExtensions().contains(extractedFile.getFileExtension())) continue;
                    List<ValidationReport> validationResult = this.validate(extractedFile, user);
                    this.postValidate(validationResult, user);
                    reports.addAll(validationResult);
                }
            }
            catch (IOException e) {
                throw new BulkUploadException("Problem while reading zip file during validation", e);
            }
        } else if (this.getSupportedFileExtensions().contains(fileUpload.getFileExtension())) {
            List<ValidationReport> validationResult = this.validate(fileUpload, user);
            this.postValidate(validationResult, user);
            reports.addAll(validationResult);
        }
        if (reports.size() == 0) {
            return new UploadModelResult(null, Arrays.asList(ValidationReport.invalid("Uploaded File does not contain any " + this.getKey() + " files.")));
        }
        if (reports.stream().filter(report -> !report.isValid()).count() == 0L) {
            return new UploadModelResult(this.createUploadHandle(fileUpload), reports);
        }
        return new UploadModelResult(this.createUploadHandle(fileUpload), reports);
    }

    private void postValidate(List<ValidationReport> reports, IUserContext user) {
        reports.forEach(report -> {
            if (report.getModel() != null && this.modelRepository.getById(report.getModel().getId()) != null) {
                ModelInfo m = this.modelRepository.getById(report.getModel().getId());
                if (m.isReleased()) {
                    report.setMessage(ValidationReport.ERROR_MODEL_ALREADY_RELEASED);
                    report.setValid(false);
                } else if (this.isAdmin(user) || m.getAuthor().equals(user.getHashedUsername()) || m.getAuthor().equals(user.getUsername())) {
                    report.setMessage(ValidationReport.WARNING_MODEL_ALREADY_EXISTS);
                    report.setValid(true);
                } else {
                    report.setMessage(ValidationReport.ERROR_MODEL_ALREADY_EXISTS);
                    report.setValid(false);
                }
            }
        });
    }

    private boolean isAdmin(IUserContext userContext) {
        User user = this.getUserRepository().findByUsername(userContext.getUsername());
        return user != null && user.isAdmin();
    }

    private static byte[] copyStream(ZipInputStream in, ZipEntry entry) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int size;
            byte[] buffer = new byte[2048];
            BufferedOutputStream bos = new BufferedOutputStream(out);
            while ((size = in.read(buffer, 0, buffer.length)) != -1) {
                bos.write(buffer, 0, size);
            }
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            throw new BulkUploadException("IOException while copying stream to ZipEntry", e);
        }
        return out.toByteArray();
    }

    private String createUploadHandle(FileUpload fileUpload) {
        String handleId = UUID.randomUUID().toString();
        return this.uploadStorage.store(handleId, fileUpload, 300L).getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ModelInfo> doImport(String uploadHandleId, IUserContext user) {
        ArrayList<ModelInfo> importedModels;
        block8: {
            StorageItem uploadedItem = this.uploadStorage.get(uploadHandleId);
            if (uploadedItem == null) {
                throw new ModelImporterException("No uploaded file found for handleId '" + uploadHandleId + "'");
            }
            importedModels = new ArrayList<ModelInfo>();
            try {
                if (this.handleZipUploads() && uploadedItem.getValue().getFileExtension().equalsIgnoreCase(EXTENSION_ZIP)) {
                    ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(uploadedItem.getValue().getContent()));
                    ZipEntry entry = null;
                    try {
                        while ((entry = zis.getNextEntry()) != null) {
                            if (entry.isDirectory() || entry.getName().substring(entry.getName().lastIndexOf("/") + 1).startsWith(".")) continue;
                            FileUpload extractedFile = FileUpload.create(entry.getName(), AbstractModelImporter.copyStream(zis, entry));
                            List<ModelResource> resources = this.convert(extractedFile, user);
                            importedModels.addAll(this.sortAndSaveToRepository(resources, extractedFile, user));
                        }
                        break block8;
                    }
                    catch (IOException e) {
                        throw new BulkUploadException("Problem while reading zip file during validation", e);
                    }
                }
                List<ModelResource> resources = this.convert(uploadedItem.getValue(), user);
                importedModels.addAll(this.sortAndSaveToRepository(resources, uploadedItem.getValue(), user));
            }
            finally {
                this.uploadStorage.remove(uploadHandleId);
            }
        }
        return importedModels;
    }

    private List<ModelInfo> sortAndSaveToRepository(List<ModelResource> resources, FileUpload extractedFile, IUserContext user) {
        ArrayList<ModelInfo> savedModels = new ArrayList<ModelInfo>();
        DependencyManager dm = new DependencyManager();
        for (ModelResource resource2 : resources) {
            dm.addResource(resource2);
        }
        dm.getSorted().stream().forEach(resource -> {
            try {
                ModelInfo importedModel = this.modelRepository.save(resource.getId(), ((ModelResource)((Object)resource)).toDSL(), this.createFileName((ModelInfo)resource), user);
                savedModels.add(importedModel);
                this.postProcessImportedModel(importedModel, new FileContent(extractedFile.getFileName(), extractedFile.getContent()), user);
            }
            catch (Exception e) {
                throw new ModelImporterException("Problem importing model", e);
            }
        });
        return savedModels;
    }

    protected boolean handleZipUploads() {
        return true;
    }

    @Override
    public Set<String> getSupportedFileExtensions() {
        return Collections.unmodifiableSet(this.supportedFileExtensions);
    }

    protected ModelResource parseDSL(String fileName, byte[] content) {
        return (ModelResource)ModelParserFactory.getParser(fileName).parse(new ByteArrayInputStream(content));
    }

    protected ModelResource parseDSL(ModelType type, byte[] content) {
        return (ModelResource)ModelParserFactory.getParser("model" + type.getExtension()).parse(new ByteArrayInputStream(content));
    }

    private String createFileName(ModelInfo resource) {
        return resource.getId().getName() + resource.getType().getExtension();
    }

    protected void postProcessImportedModel(ModelInfo importedModel, FileContent originalFileContent, IUserContext user) {
        this.getModelRepository().attachFile(importedModel.getId(), originalFileContent, user, Attachment.TAG_IMPORTED);
        importedModel.setImported(Boolean.valueOf(true));
    }

    protected abstract List<ValidationReport> validate(FileUpload var1, IUserContext var2);

    protected abstract List<ModelResource> convert(FileUpload var1, IUserContext var2);

    public void setUploadStorage(ITemporaryStorage uploadStorage) {
        this.uploadStorage = uploadStorage;
    }

    public void setModelRepository(IModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    public void setUserRepository(IUserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public ITemporaryStorage getUploadStorage() {
        return this.uploadStorage;
    }

    public IModelRepository getModelRepository() {
        return this.modelRepository;
    }

    public IUserRepository getUserRepository() {
        return this.userRepository;
    }
}

