/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.core.impl.validation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.core.impl.InvocationContext;
import org.eclipse.vorto.repository.core.impl.validation.CouldNotResolveReferenceException;
import org.eclipse.vorto.repository.core.impl.validation.IModelValidator;
import org.eclipse.vorto.repository.core.impl.validation.ValidationException;

public class ModelReferencesValidation
implements IModelValidator {
    private IModelRepository modelRepository;

    public ModelReferencesValidation(IModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    public IModelRepository getModelRepository() {
        return this.modelRepository;
    }

    @Override
    public void validate(ModelInfo modelResource, InvocationContext context) throws ValidationException {
        ArrayList<ModelId> missingReferences = new ArrayList<ModelId>();
        if (!modelResource.getReferences().isEmpty()) {
            this.checkReferencesRecursive(modelResource, missingReferences);
        }
        if (!missingReferences.isEmpty()) {
            throw new CouldNotResolveReferenceException(modelResource, missingReferences);
        }
    }

    private void checkReferencesRecursive(ModelInfo modelResource, List<ModelId> accumulator) {
        for (ModelId modelId : modelResource.getReferences()) {
            ModelInfo reference = this.modelRepository.getById(modelId);
            if (reference == null) {
                accumulator.add(modelId);
                continue;
            }
            if (modelResource.getId().equals((Object)reference.getId())) {
                throw new ValidationException("Cyclic dependency detected for reference '" + reference.getId() + "'", modelResource);
            }
            if (modelResource.getType().canHandleReference(reference)) {
                this.checkReferencesRecursive(reference, accumulator);
                continue;
            }
            throw new ValidationException("Reference '" + reference.getId() + "' is not valid for this model type.", modelResource);
        }
    }
}

