/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.mapping.MappingModel;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.api.model.model.ModelReference;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.api.ModelType;

public class ModelResource
extends ModelInfo {
    private Model model;

    public ModelResource(Model model) {
        super(new ModelId(model.getName(), model.getNamespace(), model.getVersion()), ModelResource.createModelType(model));
        this.model = model;
    }

    private static ModelType createModelType(Model model) {
        if (model instanceof Type) {
            return ModelType.Datatype;
        }
        if (model instanceof FunctionblockModel) {
            return ModelType.Functionblock;
        }
        if (model instanceof InformationModel) {
            return ModelType.InformationModel;
        }
        if (model instanceof MappingModel) {
            return ModelType.Mapping;
        }
        throw new UnsupportedOperationException("Model of type " + model.getClass() + " cannot be parsed");
    }

    public ModelId getId() {
        return new ModelId(this.model.getName(), this.model.getNamespace(), this.model.getVersion());
    }

    public String getDisplayName() {
        return this.model.getDisplayname() != null ? this.model.getDisplayname() : this.getId().getName();
    }

    public String getDescription() {
        return this.model.getDescription();
    }

    public List<ModelId> getReferences() {
        ArrayList<ModelId> references = new ArrayList<ModelId>(this.model.getReferences().size());
        for (ModelReference source : this.model.getReferences()) {
            references.add(ModelId.fromReference((String)source.getImportedNamespace(), (String)source.getVersion()));
        }
        return references;
    }

    public byte[] toDSL() throws IOException {
        Resource resource = this.model.eResource().getResourceSet().createResource(URI.createURI((String)(this.model.getName() + this.type.getExtension())));
        resource.getContents().add((Object)this.model);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        resource.save((OutputStream)baos, null);
        return baos.toByteArray();
    }

    public boolean matchesTargetPlatform(String targetPlatform) {
        return this.type == ModelType.Mapping && ((MappingModel)this.model).getTargetPlatform().equalsIgnoreCase(targetPlatform);
    }

    public String getTargetPlatform() {
        if (this.model instanceof MappingModel) {
            return ((MappingModel)this.model).getTargetPlatform();
        }
        return "";
    }

    public Model getModel() {
        return this.model;
    }
}

