/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.ui;

import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.exception.ModelNotFoundException;
import org.eclipse.vorto.repository.api.resolver.ResolveQuery;
import org.eclipse.vorto.repository.core.IModelIdResolver;
import org.eclipse.vorto.repository.core.impl.resolver.UnknownModelIdResolverException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/resolve"})
public class ModelDetailsResolver {
    @Autowired
    private IModelIdResolver resolver;

    @RequestMapping(value={"/{serviceKey}/{stereotype}/{attributeId}/{attributeValue}"}, method={RequestMethod.GET})
    public String resolve(@PathVariable(value="serviceKey") String serviceKey, @PathVariable(value="stereotype") String stereoType, @PathVariable(value="attributeId") String attributeId, @PathVariable(value="attributeValue") String attributeValue) throws Exception {
        ModelId resolvedId = this.resolver.resolve(new ResolveQuery(serviceKey, attributeId, attributeValue, stereoType));
        if (resolvedId != null) {
            return "redirect:/#/details/" + resolvedId.getNamespace() + "/" + resolvedId.getName() + "/" + resolvedId.getVersion();
        }
        throw new ModelNotFoundException("No Model found");
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="Model not found.")
    @ExceptionHandler(value={ModelNotFoundException.class})
    public void NotFound(ModelNotFoundException ex) {
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="Unknown resolver.")
    @ExceptionHandler(value={UnknownModelIdResolverException.class})
    public void UnknownModelIdResolver(UnknownModelIdResolverException ex) {
    }
}

