/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.listeners;

import java.io.IOException;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.vorto.repository.account.UserUtils;
import org.eclipse.vorto.repository.account.impl.IUserRepository;
import org.eclipse.vorto.repository.account.impl.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationSuccessHandler
extends SimpleUrlAuthenticationSuccessHandler {
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    @Autowired
    private IUserRepository userRepository;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        this.handle(request, response, authentication);
        this.clearAuthenticationAttributes(request);
    }

    protected void handle(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        OAuth2Authentication auth = (OAuth2Authentication)authentication;
        Optional<User> _user = Optional.ofNullable(this.userRepository.findByUsername(auth.getName()));
        String targetUrl = _user.map(user -> {
            UserUtils.refreshSpringSecurityUser(user);
            return "/#/";
        }).orElse("/#/signup");
        if (response.isCommitted()) {
            this.logger.debug((Object)("Response has already been committed. Unable to redirect to " + targetUrl));
            return;
        }
        this.redirectStrategy.sendRedirect(request, response, targetUrl);
    }

    public void setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
    }

    protected RedirectStrategy getRedirectStrategy() {
        return this.redirectStrategy;
    }
}

