/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.core;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.eclipse.vorto.core.api.model.mapping.MappingModel;
import org.eclipse.vorto.repository.api.AbstractModel;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.api.exception.ModelNotFoundException;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.core.IUserContext;
import org.eclipse.vorto.repository.core.impl.UserContext;
import org.eclipse.vorto.repository.web.AbstractRepositoryController;
import org.eclipse.vorto.repository.web.core.ModelDtoFactory;
import org.eclipse.vorto.repository.web.core.exceptions.UploadTooLargeException;
import org.eclipse.vorto.server.commons.reader.IModelWorkspace;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(value="/find", description="Find information models")
@RestController
@RequestMapping(value={"/rest/model"})
public class ModelRepositoryController
extends AbstractRepositoryController {
    private static final String ATTACHMENT_FILENAME = "attachment; filename = ";
    private static final String XMI = ".xmi";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String CONTENT_DISPOSITION = "content-disposition";
    @Value(value="${server.config.maxModelImageSize}")
    private long maxModelImageSize;
    @Autowired
    private IModelRepository modelRepository;
    private static Logger logger = Logger.getLogger(ModelRepositoryController.class);

    @ApiOperation(value="Find a model by a free-text search expression")
    @RequestMapping(value={"/query={expression:.*}"}, method={RequestMethod.GET})
    public List<ModelInfo> searchByExpression(@ApiParam(value="a free-text search expression", required=true) @PathVariable String expression) throws UnsupportedEncodingException {
        List<ModelInfo> modelResources = this.modelRepository.search(URLDecoder.decode(expression, "utf-8"));
        logger.info((Object)("searchByExpression: [" + expression + "] Rows returned: " + modelResources.size()));
        return modelResources.stream().map(resource -> ModelDtoFactory.createDto(resource, (IUserContext)UserContext.user(SecurityContextHolder.getContext().getAuthentication().getName()))).collect(Collectors.toList());
    }

    @ApiOperation(value="Returns a model by its full qualified model ID")
    @ApiResponses(value={@ApiResponse(code=400, message="Wrong input"), @ApiResponse(code=404, message="Model not found")})
    @RequestMapping(value={"/{namespace}/{name}/{version:.+}"}, method={RequestMethod.GET})
    public ModelInfo getModelResource(@ApiParam(value="The namespace of vorto model, e.g. com.mycompany", required=true) @PathVariable String namespace, @ApiParam(value="The name of vorto model, e.g. NewInfomodel", required=true) @PathVariable String name, @ApiParam(value="The version of vorto model, e.g. 1.0.0", required=true) @PathVariable String version) {
        Objects.requireNonNull(namespace, "namespace must not be null");
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(version, "version must not be null");
        ModelId modelId = new ModelId(name, namespace, version);
        logger.info((Object)("getModelResource: [" + modelId.toString() + "]"));
        ModelInfo resource = this.modelRepository.getById(modelId);
        if (resource == null) {
            throw new ModelNotFoundException("Model does not exist", null);
        }
        return ModelDtoFactory.createDto(resource, (IUserContext)UserContext.user(SecurityContextHolder.getContext().getAuthentication().getName()));
    }

    @ApiOperation(value="Returns the model content")
    @ApiResponses(value={@ApiResponse(code=400, message="Wrong input"), @ApiResponse(code=404, message="Model not found")})
    @RequestMapping(value={"/content/{namespace}/{name}/{version:.+}"}, method={RequestMethod.GET})
    public AbstractModel getModelContent(@ApiParam(value="The namespace of vorto model, e.g. com.mycompany", required=true) @PathVariable String namespace, @ApiParam(value="The name of vorto model, e.g. NewInfomodel", required=true) @PathVariable String name, @ApiParam(value="The version of vorto model, e.g. 1.0.0", required=true) @PathVariable String version) {
        byte[] modelContent = this.createZipWithAllDependencies(new ModelId(name, namespace, version), IModelRepository.ContentType.DSL);
        IModelWorkspace workspace = IModelWorkspace.newReader().addZip(new ZipInputStream(new ByteArrayInputStream(modelContent))).read();
        return ModelDtoFactory.createResource(workspace.get().stream().filter(p -> p.getName().equals(name)).findFirst().get(), Optional.empty());
    }

    @ApiOperation(value="Returns the model content including target platform specific attributes")
    @ApiResponses(value={@ApiResponse(code=400, message="Wrong input"), @ApiResponse(code=404, message="Model not found")})
    @RequestMapping(value={"/content/{namespace}/{name}/{version:.+}/mapping/{targetplatformKey}"}, method={RequestMethod.GET})
    public AbstractModel getModelContentForTargetPlatform(@ApiParam(value="The namespace of vorto model, e.g. com.mycompany", required=true) @PathVariable String namespace, @ApiParam(value="The name of vorto model, e.g. NewInfomodel", required=true) @PathVariable String name, @ApiParam(value="The version of vorto model, e.g. 1.0.0", required=true) @PathVariable String version, @ApiParam(value="The key of the targetplatform, e.g. lwm2m", required=true) @PathVariable String targetplatformKey) {
        List<ModelInfo> mappingResource = this.modelRepository.getMappingModelsForTargetPlatform(new ModelId(name, namespace, version), targetplatformKey);
        if (!mappingResource.isEmpty()) {
            byte[] mappingContentZip = this.createZipWithAllDependencies(mappingResource.get(0).getId(), IModelRepository.ContentType.DSL);
            IModelWorkspace workspace = IModelWorkspace.newReader().addZip(new ZipInputStream(new ByteArrayInputStream(mappingContentZip))).read();
            MappingModel mappingModel = (MappingModel)workspace.get().stream().filter(p -> p instanceof MappingModel).findFirst().get();
            byte[] modelContent = this.createZipWithAllDependencies(new ModelId(name, namespace, version), IModelRepository.ContentType.DSL);
            workspace = IModelWorkspace.newReader().addZip(new ZipInputStream(new ByteArrayInputStream(modelContent))).read();
            return ModelDtoFactory.createResource(workspace.get().stream().filter(p -> p.getName().equals(name)).findFirst().get(), Optional.of(mappingModel));
        }
        return this.getModelContent(namespace, name, version);
    }

    @ApiOperation(value="Returns the model content including target platform specific attributes for the given model- and mapping modelID")
    @ApiResponses(value={@ApiResponse(code=400, message="Wrong input"), @ApiResponse(code=404, message="Model not found")})
    @RequestMapping(value={"/content/{modelId:.+}/mapping/{mappingId:.+}"}, method={RequestMethod.GET})
    public AbstractModel getModelContentByModelAndMappingId(@ApiParam(value="The model ID (prettyFormat)", required=true) @PathVariable String modelId, @ApiParam(value="The mapping Model ID (prettyFormat)", required=true) @PathVariable String mappingId) {
        ModelInfo vortoModelInfo = this.modelRepository.getById(ModelId.fromPrettyFormat((String)modelId));
        ModelInfo mappingModelInfo = this.modelRepository.getById(ModelId.fromPrettyFormat((String)mappingId));
        if (vortoModelInfo == null) {
            throw new ModelNotFoundException("Could not find vorto model with ID: " + modelId);
        }
        if (mappingModelInfo == null) {
            throw new ModelNotFoundException("Could not find mapping with ID: " + mappingId);
        }
        byte[] mappingContentZip = this.createZipWithAllDependencies(mappingModelInfo.getId(), IModelRepository.ContentType.DSL);
        IModelWorkspace workspace = IModelWorkspace.newReader().addZip(new ZipInputStream(new ByteArrayInputStream(mappingContentZip))).read();
        MappingModel mappingModel = (MappingModel)workspace.get().stream().filter(p -> p instanceof MappingModel).findFirst().get();
        byte[] modelContent = this.createZipWithAllDependencies(vortoModelInfo.getId(), IModelRepository.ContentType.DSL);
        workspace = IModelWorkspace.newReader().addZip(new ZipInputStream(new ByteArrayInputStream(modelContent))).read();
        return ModelDtoFactory.createResource(workspace.get().stream().filter(p -> p.getName().equals(vortoModelInfo.getId().getName())).findFirst().get(), Optional.of(mappingModel));
    }

    @ApiOperation(value="Returns the image of a vorto model")
    @ApiResponses(value={@ApiResponse(code=400, message="Wrong input"), @ApiResponse(code=404, message="Model not found")})
    @RequestMapping(value={"/image/{namespace}/{name}/{version:.+}"}, method={RequestMethod.GET})
    public void getModelImage(@ApiParam(value="The namespace of vorto model, e.g. com.mycompany", required=true) @PathVariable String namespace, @ApiParam(value="The name of vorto model, e.g. NewInfomodel", required=true) @PathVariable String name, @ApiParam(value="The version of vorto model, e.g. 1.0.0", required=true) @PathVariable String version, @ApiParam(value="Response", required=true) HttpServletResponse response) {
        Objects.requireNonNull(namespace, "namespace must not be null");
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(version, "version must not be null");
        ModelId modelId = new ModelId(name, namespace, version);
        byte[] modelImage = this.modelRepository.getModelImage(modelId);
        response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + modelId.getName() + ".png");
        response.setContentType(APPLICATION_OCTET_STREAM);
        try {
            IOUtils.copy((InputStream)new ByteArrayInputStream(modelImage), (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException("Error copying file.", e);
        }
    }

    @ApiOperation(value="Adds an image for a vorto model", hidden=true)
    @ApiResponses(value={@ApiResponse(code=400, message="Wrong input"), @ApiResponse(code=404, message="Model not found")})
    @RequestMapping(value={"/image"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void uploadModelImage(@ApiParam(value="The image to upload", required=true) @RequestParam(value="file") MultipartFile file, @ApiParam(value="The namespace of vorto model, e.g. com.mycompany", required=true) @RequestParam String namespace, @ApiParam(value="The name of vorto model, e.g. NewInfomodel", required=true) @RequestParam String name, @ApiParam(value="The version of vorto model, e.g. 1.0.0", required=true) @RequestParam String version) {
        if (file.getSize() > this.maxModelImageSize) {
            throw new UploadTooLargeException("model image", this.maxModelImageSize);
        }
        logger.info((Object)("uploadImage: [" + file.getOriginalFilename() + ", " + file.getSize() + "]"));
        try {
            this.modelRepository.addModelImage(new ModelId(name, namespace, version), file.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @ApiOperation(value="Downloads the model content in a specific output format")
    @ApiResponses(value={@ApiResponse(code=400, message="Wrong input"), @ApiResponse(code=404, message="Model not found")})
    @RequestMapping(value={"/file/{namespace}/{name}/{version:.+}"}, method={RequestMethod.GET})
    public void downloadModelById(@ApiParam(value="The namespace of vorto model, e.g. com.mycompany", required=true) @PathVariable String namespace, @ApiParam(value="The name of vorto model, e.g. NewInfomodel", required=true) @PathVariable String name, @ApiParam(value="The version of vorto model, e.g. 1.0.0", required=true) @PathVariable String version, @ApiParam(value="Choose output file format, e.g. DSL", required=true) @RequestParam(value="output", required=false) IModelRepository.ContentType outputType, @ApiParam(value="Set true if dependencies shall be included", required=false) @RequestParam(value="includeDependencies", required=false) boolean includeDependencies, HttpServletResponse response) {
        Objects.requireNonNull(namespace, "namespace must not be null");
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(version, "version must not be null");
        ModelId modelId = new ModelId(name, namespace, version);
        logger.info((Object)("downloadModelById: [" + modelId.toString() + "]"));
        IModelRepository.ContentType contentType = outputType;
        if (includeDependencies) {
            byte[] zipContent = this.createZipWithAllDependencies(modelId, contentType);
            response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + modelId.getNamespace() + "_" + modelId.getName() + "_" + modelId.getVersion() + ".zip");
            response.setContentType(APPLICATION_OCTET_STREAM);
            try {
                IOUtils.copy((InputStream)new ByteArrayInputStream(zipContent), (OutputStream)response.getOutputStream());
                response.flushBuffer();
            }
            catch (IOException e) {
                throw new RuntimeException("Error copying file.", e);
            }
        } else {
            this.createSingleModelContent(modelId, contentType, response);
        }
    }

    private byte[] createZipWithAllDependencies(ModelId modelId, IModelRepository.ContentType contentType) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        try {
            this.addModelToZip(zos, modelId, contentType);
            zos.close();
            baos.close();
            return baos.toByteArray();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void createSingleModelContent(ModelId modelId, IModelRepository.ContentType contentType, HttpServletResponse response) {
        byte[] modelContent = this.modelRepository.getModelContent(modelId, contentType).getContent();
        if (modelContent != null && modelContent.length > 0) {
            ModelInfo modelResource = this.modelRepository.getById(modelId);
            response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + this.getFileName(modelResource, contentType));
            response.setContentType(APPLICATION_OCTET_STREAM);
            try {
                IOUtils.copy((InputStream)new ByteArrayInputStream(modelContent), (OutputStream)response.getOutputStream());
                response.flushBuffer();
            }
            catch (IOException e) {
                throw new RuntimeException("Error copying file.", e);
            }
        } else {
            throw new RuntimeException("File not found.");
        }
    }

    private void addModelToZip(ZipOutputStream zipOutputStream, ModelId modelId, IModelRepository.ContentType contentType) throws Exception {
        byte[] modelContent = this.modelRepository.getModelContent(modelId, contentType).getContent();
        ModelInfo modelResource = this.modelRepository.getById(modelId);
        try {
            ZipEntry zipEntry = new ZipEntry(this.getFileName(modelResource, contentType));
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(modelContent);
            zipOutputStream.closeEntry();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (ModelId reference : modelResource.getReferences()) {
            this.addModelToZip(zipOutputStream, reference, contentType);
        }
    }

    private String getFileName(ModelInfo modelResource, IModelRepository.ContentType contentType) {
        if (contentType == IModelRepository.ContentType.XMI) {
            return modelResource.getId().getName() + XMI;
        }
        return modelResource.getId().getName() + modelResource.getType().getExtension();
    }

    @ApiOperation(value="Getting all mapping resources")
    @RequestMapping(value={"/mapping/zip/{namespace}/{name}/{version:.+}/{targetPlatform}"}, method={RequestMethod.GET})
    public void getMappingResources(@ApiParam(value="The namespace of vorto model, e.g. com.mycompany", required=true) @PathVariable String namespace, @ApiParam(value="The name of vorto model, e.g. NewInfomodel", required=true) @PathVariable String name, @ApiParam(value="The version of vorto model, e.g. 1.0.0", required=true) @PathVariable String version, @ApiParam(value="The name of target platform, e.g. lwm2m", required=true) @PathVariable String targetPlatform, HttpServletResponse response) {
        Objects.requireNonNull(namespace, "namespace must not be null");
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(version, "version must not be null");
        ModelId modelId = new ModelId(name, namespace, version);
        List<ModelInfo> mappingResources = this.modelRepository.getMappingModelsForTargetPlatform(modelId, targetPlatform);
        String fileName = modelId.getNamespace() + "_" + modelId.getName() + "_" + modelId.getVersion() + ".zip";
        this.sendAsZipFile(response, fileName, mappingResources);
    }

    @RequestMapping(value={"/mine"}, method={RequestMethod.GET})
    public void getUserModels(Principal user, HttpServletResponse response) {
        List<ModelInfo> userModels = this.modelRepository.search("author:" + UserContext.user(user.getName()).getHashedUsername());
        logger.info((Object)("Exporting information models for " + user.getName() + " results: " + userModels.size()));
        this.sendAsZipFile(response, user.getName() + "-models.zip", userModels);
    }

    private void sendAsZipFile(HttpServletResponse response, String fileName, List<ModelInfo> modelInfos) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        IModelRepository.ContentType contentType = IModelRepository.ContentType.DSL;
        try {
            for (ModelInfo modelInfo : modelInfos) {
                this.addModelToZip(zos, modelInfo.getId(), contentType);
            }
            zos.close();
            baos.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + fileName);
        response.setContentType(APPLICATION_OCTET_STREAM);
        try {
            IOUtils.copy((InputStream)new ByteArrayInputStream(baos.toByteArray()), (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException("Error copying file.", e);
        }
    }
}

