/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.core;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.vorto.core.api.model.datatype.BooleanPropertyAttribute;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.EnumLiteral;
import org.eclipse.vorto.core.api.model.datatype.EnumLiteralPropertyAttribute;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyAttribute;
import org.eclipse.vorto.core.api.model.functionblock.Event;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.PrimitiveParam;
import org.eclipse.vorto.core.api.model.functionblock.RefParam;
import org.eclipse.vorto.core.api.model.functionblock.ReturnObjectType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnPrimitiveType;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.mapping.Attribute;
import org.eclipse.vorto.core.api.model.mapping.ConfigurationSource;
import org.eclipse.vorto.core.api.model.mapping.EntitySource;
import org.eclipse.vorto.core.api.model.mapping.FaultSource;
import org.eclipse.vorto.core.api.model.mapping.FunctionBlockAttributeSource;
import org.eclipse.vorto.core.api.model.mapping.FunctionBlockPropertySource;
import org.eclipse.vorto.core.api.model.mapping.InfoModelAttributeSource;
import org.eclipse.vorto.core.api.model.mapping.InfoModelPropertySource;
import org.eclipse.vorto.core.api.model.mapping.MappingModel;
import org.eclipse.vorto.core.api.model.mapping.MappingRule;
import org.eclipse.vorto.core.api.model.mapping.OperationSource;
import org.eclipse.vorto.core.api.model.mapping.ReferenceTarget;
import org.eclipse.vorto.core.api.model.mapping.Source;
import org.eclipse.vorto.core.api.model.mapping.StatusSource;
import org.eclipse.vorto.core.api.model.mapping.StereoTypeTarget;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.api.model.model.ModelReference;
import org.eclipse.vorto.repository.api.AbstractModel;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.api.ModelType;
import org.eclipse.vorto.repository.api.content.BooleanAttributeProperty;
import org.eclipse.vorto.repository.api.content.BooleanAttributePropertyType;
import org.eclipse.vorto.repository.api.content.Constraint;
import org.eclipse.vorto.repository.api.content.ConstraintType;
import org.eclipse.vorto.repository.api.content.EntityModel;
import org.eclipse.vorto.repository.api.content.EnumAttributeProperty;
import org.eclipse.vorto.repository.api.content.EnumAttributePropertyType;
import org.eclipse.vorto.repository.api.content.EnumModel;
import org.eclipse.vorto.repository.api.content.IPropertyAttribute;
import org.eclipse.vorto.repository.api.content.IReferenceType;
import org.eclipse.vorto.repository.api.content.Infomodel;
import org.eclipse.vorto.repository.api.content.ModelEvent;
import org.eclipse.vorto.repository.api.content.ModelProperty;
import org.eclipse.vorto.repository.api.content.Param;
import org.eclipse.vorto.repository.api.content.ReturnType;
import org.eclipse.vorto.repository.api.content.Stereotype;
import org.eclipse.vorto.repository.comment.Comment;
import org.eclipse.vorto.repository.core.IUserContext;

public class ModelDtoFactory {
    public static ModelInfo createDto(ModelInfo resource, IUserContext userContext) {
        ModelInfo dto = new ModelInfo(ModelDtoFactory.createDto(resource.getId()), ModelType.valueOf((String)resource.getType().name()));
        if (userContext.getHashedUsername().equals(resource.getAuthor())) {
            dto.setAuthor(userContext.getUsername());
        }
        dto.setCreationDate(resource.getCreationDate());
        dto.setDescription(resource.getDescription());
        dto.setDisplayName(resource.getDisplayName());
        dto.setHasImage(resource.isHasImage());
        dto.setReferencedBy(resource.getReferencedBy().stream().map(r -> ModelDtoFactory.createDto(r)).collect(Collectors.toList()));
        dto.setReferences(resource.getReferences().stream().map(r -> ModelDtoFactory.createDto(r)).collect(Collectors.toList()));
        dto.setPlatformMappings(resource.getPlatformMappings());
        return dto;
    }

    public static Comment createDto(Comment comment, IUserContext userContext) {
        if (userContext.getHashedUsername().equals(comment.getAuthor())) {
            comment.setAuthor(userContext.getUsername());
        }
        return comment;
    }

    public static ModelId createDto(ModelId modelId) {
        return new ModelId(modelId.getName(), modelId.getNamespace(), modelId.getVersion());
    }

    public static AbstractModel createResource(Model model, Optional<MappingModel> mappingModel) {
        if (model instanceof InformationModel) {
            return ModelDtoFactory.createResource((InformationModel)model, mappingModel);
        }
        if (model instanceof FunctionblockModel) {
            return ModelDtoFactory.createResource((FunctionblockModel)model, mappingModel);
        }
        if (model instanceof Entity) {
            return ModelDtoFactory.createResource((Entity)model, mappingModel);
        }
        if (model instanceof Enum) {
            return ModelDtoFactory.createResource((Model)((Enum)model), mappingModel);
        }
        if (model instanceof MappingModel) {
            return new ModelInfo(new ModelId(model.getName(), model.getNamespace(), model.getVersion()), ModelType.Mapping);
        }
        throw new UnsupportedOperationException();
    }

    public static Infomodel createResource(InformationModel model, Optional<MappingModel> mappingModel) {
        Infomodel infoResource = new Infomodel(new ModelId(model.getName(), model.getNamespace(), model.getVersion()), ModelType.InformationModel);
        for (FunctionblockProperty property : model.getProperties()) {
            infoResource.getFunctionblocks().add(ModelDtoFactory.createProperty(property, mappingModel));
        }
        infoResource.setDescription(model.getDescription());
        infoResource.setDisplayName(model.getDisplayname());
        infoResource.setReferences(model.getReferences().stream().map(reference -> ModelDtoFactory.createModelId(reference)).collect(Collectors.toList()));
        if (mappingModel.isPresent()) {
            MappingModel _mappingModel = mappingModel.get();
            infoResource.setTargetPlatformKey(_mappingModel.getTargetPlatform());
            for (MappingRule rule : ModelDtoFactory.getInfoModelRule((List<MappingRule>)_mappingModel.getRules())) {
                StereoTypeTarget target;
                if (rule.getTarget() instanceof StereoTypeTarget) {
                    target = (StereoTypeTarget)rule.getTarget();
                    infoResource.addStereotype(Stereotype.create((String)target.getName(), ModelDtoFactory.convertAttributesToMap((List<Attribute>)target.getAttributes())));
                    continue;
                }
                if (!(rule.getTarget() instanceof ReferenceTarget)) continue;
                target = (ReferenceTarget)rule.getTarget();
                infoResource.setMappingReference(ModelDtoFactory.createModelId((Model)target.getMappingModel()));
            }
        }
        return infoResource;
    }

    private static List<MappingRule> getInfoModelRule(List<MappingRule> rules) {
        return rules.stream().filter(r -> r.getSources().get(0) instanceof InfoModelAttributeSource).collect(Collectors.toList());
    }

    private static ModelId createModelId(Model model) {
        return new ModelId(model.getName(), model.getNamespace(), model.getVersion());
    }

    private static ModelId createModelId(ModelReference reference) {
        ModelId modelId = ModelId.fromReference((String)reference.getImportedNamespace(), (String)reference.getVersion());
        return new ModelId(modelId.getName(), modelId.getNamespace(), modelId.getVersion());
    }

    public static org.eclipse.vorto.repository.api.content.FunctionblockModel createResource(FunctionblockModel model, Optional<MappingModel> mappingModel) {
        org.eclipse.vorto.repository.api.content.FunctionblockModel resource = new org.eclipse.vorto.repository.api.content.FunctionblockModel(new ModelId(model.getName(), model.getNamespace(), model.getVersion()), ModelType.Functionblock);
        resource.setDescription(model.getDescription());
        resource.setDisplayName(model.getDisplayname());
        resource.setReferences(model.getReferences().stream().map(reference -> ModelDtoFactory.createModelId(reference)).collect(Collectors.toList()));
        if (model.getFunctionblock().getConfiguration() != null) {
            resource.setConfigurationProperties(model.getFunctionblock().getConfiguration().getProperties().stream().map(p -> ModelDtoFactory.createProperty(p, mappingModel)).collect(Collectors.toList()));
        }
        if (model.getFunctionblock().getStatus() != null) {
            resource.setStatusProperties(model.getFunctionblock().getStatus().getProperties().stream().map(p -> ModelDtoFactory.createProperty(p, mappingModel)).collect(Collectors.toList()));
        }
        if (model.getFunctionblock().getFault() != null) {
            resource.setFaultProperties(model.getFunctionblock().getFault().getProperties().stream().map(p -> ModelDtoFactory.createProperty(p, mappingModel)).collect(Collectors.toList()));
        }
        if (model.getFunctionblock().getEvents() != null) {
            resource.setEvents(model.getFunctionblock().getEvents().stream().map(e -> ModelDtoFactory.createEvent(e, mappingModel)).collect(Collectors.toList()));
        }
        if (model.getFunctionblock().getOperations() != null) {
            resource.setOperations(model.getFunctionblock().getOperations().stream().map(o -> ModelDtoFactory.createOperation(o, mappingModel)).collect(Collectors.toList()));
        }
        if (mappingModel.isPresent()) {
            MappingModel _mappingModel = mappingModel.get();
            resource.setTargetPlatformKey(_mappingModel.getTargetPlatform());
            for (MappingRule rule : ModelDtoFactory.getFbRule((List<MappingRule>)_mappingModel.getRules())) {
                StereoTypeTarget target = (StereoTypeTarget)rule.getTarget();
                resource.addStereotype(Stereotype.create((String)target.getName(), ModelDtoFactory.convertAttributesToMap((List<Attribute>)target.getAttributes())));
            }
        }
        return resource;
    }

    private static Map<String, String> convertAttributesToMap(List<Attribute> attributes) {
        Map<String, String> result = attributes.stream().collect(Collectors.toMap(Attribute::getName, Attribute::getValue));
        return result;
    }

    private static List<MappingRule> getFbRule(List<MappingRule> rules) {
        return rules.stream().filter(r -> r.getSources().get(0) instanceof FunctionBlockAttributeSource).collect(Collectors.toList());
    }

    private static org.eclipse.vorto.repository.api.content.Operation createOperation(Operation o, Optional<MappingModel> mappingModel) {
        org.eclipse.vorto.repository.api.content.Operation operation = new org.eclipse.vorto.repository.api.content.Operation();
        operation.setBreakable(o.isBreakable());
        operation.setDescription(o.getDescription());
        operation.setName(o.getName());
        operation.setParams(o.getParams().stream().map(p -> ModelDtoFactory.createParam(p, mappingModel)).collect(Collectors.toList()));
        if (o.getReturnType() != null) {
            ReturnType returnType = new ReturnType();
            returnType.setMultiple(o.getReturnType().isMultiplicity());
            if (o.getReturnType() instanceof ReturnPrimitiveType) {
                returnType.setPrimitive(true);
                PrimitiveType pt = ((ReturnPrimitiveType)o.getReturnType()).getReturnType();
                returnType.setType((IReferenceType)org.eclipse.vorto.repository.api.content.PrimitiveType.valueOf((String)pt.name()));
            } else {
                returnType.setPrimitive(false);
                returnType.setType((IReferenceType)ModelDtoFactory.createModelId((Model)((ReturnObjectType)o.getReturnType()).getReturnType()));
            }
            operation.setResult(returnType);
        }
        if (mappingModel.isPresent()) {
            operation.setTargetPlatformKey(mappingModel.get().getTargetPlatform());
            for (MappingRule rule : ModelDtoFactory.getOperationRule(operation.getName(), (List<MappingRule>)mappingModel.get().getRules())) {
                StereoTypeTarget target;
                if (rule.getTarget() instanceof StereoTypeTarget) {
                    target = (StereoTypeTarget)rule.getTarget();
                    operation.addStereotype(Stereotype.create((String)target.getName(), ModelDtoFactory.convertAttributesToMap((List<Attribute>)target.getAttributes())));
                    continue;
                }
                if (!(rule.getTarget() instanceof ReferenceTarget)) continue;
                target = (ReferenceTarget)rule.getTarget();
                operation.setMappingReference(ModelDtoFactory.createModelId((Model)target.getMappingModel()));
            }
        }
        return operation;
    }

    private static Param createParam(org.eclipse.vorto.core.api.model.functionblock.Param p, Optional<MappingModel> mappingModel) {
        Param param = new Param();
        param.setDescription(p.getDescription());
        param.setMultiple(p.isMultiplicity());
        param.setName(p.getName());
        if (p instanceof PrimitiveParam) {
            PrimitiveType pt = ((PrimitiveParam)p).getType();
            param.setType((IReferenceType)org.eclipse.vorto.repository.api.content.PrimitiveType.valueOf((String)pt.name()));
            if (((PrimitiveParam)p).getConstraintRule() != null && ((PrimitiveParam)p).getConstraintRule().getConstraints() != null) {
                List constraints = ((PrimitiveParam)p).getConstraintRule().getConstraints().stream().map(c -> ModelDtoFactory.createConstraint(c)).collect(Collectors.toList());
                param.setConstraints(constraints);
            }
        } else {
            param.setType((IReferenceType)ModelDtoFactory.createModelId((Model)((RefParam)p).getType()));
        }
        if (mappingModel.isPresent()) {
            param.setTargetPlatformKey(mappingModel.get().getTargetPlatform());
            for (MappingRule rule : ModelDtoFactory.getParamRule(((Operation)p.eContainer()).getName(), param.getName(), (List<MappingRule>)mappingModel.get().getRules())) {
                StereoTypeTarget target;
                if (rule.getTarget() instanceof StereoTypeTarget) {
                    target = (StereoTypeTarget)rule.getTarget();
                    param.addStereotype(Stereotype.create((String)target.getName(), ModelDtoFactory.convertAttributesToMap((List<Attribute>)target.getAttributes())));
                    continue;
                }
                if (!(rule.getTarget() instanceof ReferenceTarget)) continue;
                target = (ReferenceTarget)rule.getTarget();
                param.setMappingReference(ModelDtoFactory.createModelId((Model)target.getMappingModel()));
            }
        }
        return param;
    }

    private static ModelProperty createProperty(FunctionblockProperty property, Optional<MappingModel> mappingModel) {
        ModelProperty p = new ModelProperty();
        p.setDescription(property.getDescription());
        p.setName(property.getName());
        p.setType((IReferenceType)ModelDtoFactory.createModelId((Model)property.getType()));
        if (mappingModel.isPresent()) {
            p.setTargetPlatformKey(mappingModel.get().getTargetPlatform());
            for (MappingRule rule : ModelDtoFactory.getPropertyRule(p.getName(), (List<MappingRule>)mappingModel.get().getRules())) {
                StereoTypeTarget target;
                if (rule.getTarget() instanceof StereoTypeTarget) {
                    target = (StereoTypeTarget)rule.getTarget();
                    p.addStereotype(Stereotype.create((String)target.getName(), ModelDtoFactory.convertAttributesToMap((List<Attribute>)target.getAttributes())));
                    continue;
                }
                if (!(rule.getTarget() instanceof ReferenceTarget)) continue;
                target = (ReferenceTarget)rule.getTarget();
                p.setMappingReference(ModelDtoFactory.createModelId((Model)target.getMappingModel()));
            }
        }
        return p;
    }

    private static ModelProperty createProperty(Property property, Optional<MappingModel> mappingModel) {
        ModelProperty p = new ModelProperty();
        p.setDescription(property.getDescription());
        p.setMandatory(property.getPresence() != null ? property.getPresence().isMandatory() : true);
        p.setMultiple(property.isMultiplicity());
        p.setName(property.getName());
        if (property.getType() instanceof PrimitivePropertyType) {
            PrimitiveType pt = ((PrimitivePropertyType)property.getType()).getType();
            p.setType((IReferenceType)org.eclipse.vorto.repository.api.content.PrimitiveType.valueOf((String)pt.name()));
        } else {
            p.setType((IReferenceType)ModelDtoFactory.createModelId((Model)((ObjectPropertyType)property.getType()).getType()));
        }
        if (property.getConstraintRule() != null && property.getConstraintRule().getConstraints() != null) {
            List constraints = property.getConstraintRule().getConstraints().stream().map(c -> ModelDtoFactory.createConstraint(c)).collect(Collectors.toList());
            p.setConstraints(constraints);
        }
        if (property.getPropertyAttributes() != null) {
            List attributes = property.getPropertyAttributes().stream().map(a -> ModelDtoFactory.createAttribute(a)).collect(Collectors.toList());
            p.setAttributes(attributes);
        }
        if (mappingModel.isPresent()) {
            p.setTargetPlatformKey(mappingModel.get().getTargetPlatform());
            for (MappingRule rule : ModelDtoFactory.getPropertyRule(p.getName(), (List<MappingRule>)mappingModel.get().getRules())) {
                StereoTypeTarget target = (StereoTypeTarget)rule.getTarget();
                p.addStereotype(Stereotype.create((String)target.getName(), ModelDtoFactory.convertAttributesToMap((List<Attribute>)target.getAttributes())));
            }
        }
        return p;
    }

    private static List<MappingRule> getPropertyRule(String propertyName, List<MappingRule> rules) {
        return rules.stream().filter(r -> (r.getSources().get(0) instanceof FunctionBlockPropertySource || r.getSources().get(0) instanceof InfoModelPropertySource) && ModelDtoFactory.matchesProperty((Source)r.getSources().get(0), propertyName)).collect(Collectors.toList());
    }

    private static List<MappingRule> getOperationRule(String operationName, List<MappingRule> rules) {
        return rules.stream().filter(r -> r.getSources().get(0) instanceof FunctionBlockPropertySource && ModelDtoFactory.matchesOperation((Source)r.getSources().get(0), operationName)).collect(Collectors.toList());
    }

    private static List<MappingRule> getParamRule(String operationName, String paramName, List<MappingRule> rules) {
        return rules.stream().filter(r -> r.getSources().get(0) instanceof OperationSource && ModelDtoFactory.matchesOperation((Source)r.getSources().get(0), operationName) && ModelDtoFactory.matchesParam((Source)r.getSources().get(0), paramName)).collect(Collectors.toList());
    }

    private static boolean matchesProperty(Source source, String propertyName) {
        if (source instanceof ConfigurationSource && ((ConfigurationSource)source).getProperty().getName().equals(propertyName)) {
            return true;
        }
        if (source instanceof StatusSource && ((StatusSource)source).getProperty().getName().equals(propertyName)) {
            return true;
        }
        if (source instanceof FaultSource && ((FaultSource)source).getProperty().getName().equals(propertyName)) {
            return true;
        }
        return source instanceof InfoModelPropertySource && ((InfoModelPropertySource)source).getProperty().getName().equals(propertyName);
    }

    private static boolean matchesOperation(Source source, String operationName) {
        return source instanceof OperationSource && ((OperationSource)source).getOperation().getName().equals(operationName);
    }

    private static boolean matchesParam(Source source, String paramName) {
        return source instanceof OperationSource && ((OperationSource)source).getParam() != null && ((OperationSource)source).getParam().getName().equals(paramName);
    }

    private static IPropertyAttribute createAttribute(PropertyAttribute attribute) {
        if (attribute instanceof BooleanPropertyAttribute) {
            BooleanPropertyAttribute booleanAttribute = (BooleanPropertyAttribute)attribute;
            return new BooleanAttributeProperty(BooleanAttributePropertyType.valueOf((String)booleanAttribute.getType().name()), booleanAttribute.isValue());
        }
        if (attribute instanceof EnumLiteralPropertyAttribute) {
            EnumLiteralPropertyAttribute enumAttribute = (EnumLiteralPropertyAttribute)attribute;
            return new EnumAttributeProperty(EnumAttributePropertyType.valueOf((String)enumAttribute.getType().name()), ModelDtoFactory.createLiteral(enumAttribute.getValue()));
        }
        throw new UnsupportedOperationException("Property Attribute cannot be mapped");
    }

    private static Constraint createConstraint(org.eclipse.vorto.core.api.model.datatype.Constraint c) {
        return new Constraint(ConstraintType.valueOf((String)c.getType().name()), c.getConstraintValues());
    }

    private static ModelEvent createEvent(Event event, Optional<MappingModel> mappingModel) {
        ModelEvent modelEvent = new ModelEvent();
        modelEvent.setName(event.getName());
        modelEvent.setProperties(event.getProperties().stream().map(p -> ModelDtoFactory.createProperty(p, mappingModel)).collect(Collectors.toList()));
        return modelEvent;
    }

    public static EntityModel createResource(Entity model, Optional<MappingModel> mappingModel) {
        EntityModel resource = new EntityModel(new ModelId(model.getName(), model.getNamespace(), model.getVersion()), ModelType.Datatype);
        resource.setDescription(model.getDescription());
        resource.setDisplayName(model.getDisplayname());
        resource.setReferences(model.getReferences().stream().map(reference -> ModelDtoFactory.createModelId(reference)).collect(Collectors.toList()));
        resource.setProperties(model.getProperties().stream().map(p -> ModelDtoFactory.createProperty(p, mappingModel)).collect(Collectors.toList()));
        if (mappingModel.isPresent()) {
            resource.setTargetPlatformKey(mappingModel.get().getTargetPlatform());
            for (MappingRule rule : ModelDtoFactory.getEntityRule((List<MappingRule>)mappingModel.get().getRules())) {
                StereoTypeTarget target = (StereoTypeTarget)rule.getTarget();
                resource.addStereotype(Stereotype.create((String)target.getName(), ModelDtoFactory.convertAttributesToMap((List<Attribute>)target.getAttributes())));
            }
        }
        return resource;
    }

    private static List<MappingRule> getEntityRule(List<MappingRule> rules) {
        return rules.stream().filter(r -> r.getSources().get(0) instanceof EntitySource).collect(Collectors.toList());
    }

    public static EnumModel createResource(Enum model) {
        EnumModel resource = new EnumModel(new ModelId(model.getName(), model.getNamespace(), model.getVersion()), ModelType.Datatype);
        resource.setDescription(model.getDescription());
        resource.setDisplayName(model.getDisplayname());
        resource.setReferences(model.getReferences().stream().map(reference -> ModelDtoFactory.createModelId(reference)).collect(Collectors.toList()));
        resource.setLiterals(model.getEnums().stream().map(p -> ModelDtoFactory.createLiteral(p)).collect(Collectors.toList()));
        return resource;
    }

    private static org.eclipse.vorto.repository.api.content.EnumLiteral createLiteral(EnumLiteral literal) {
        return new org.eclipse.vorto.repository.api.content.EnumLiteral(literal.getName(), literal.getDescription());
    }
}

