/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.account;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.security.Principal;
import org.eclipse.vorto.repository.account.IUserAccountService;
import org.eclipse.vorto.repository.account.impl.IUserRepository;
import org.eclipse.vorto.repository.web.account.UserDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(value="User Controller", description="REST API to manage user accounts")
@RestController
@RequestMapping(value={"/rest"})
public class UserController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IUserRepository userRepository;
    @Autowired
    private IUserAccountService accountService;

    @ApiOperation(value="Returns a specified User")
    @ApiResponses(value={@ApiResponse(code=404, message="Not found"), @ApiResponse(code=200, message="OK")})
    @RequestMapping(method={RequestMethod.GET}, value={"/users/{username:.+}"})
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or #username == authentication.name")
    public ResponseEntity<UserDto> getUser(@ApiParam(value="Username", required=true) @PathVariable String username) {
        this.LOGGER.debug("User {} - {} ", (Object)username, (Object)this.userRepository.findByUsername(username));
        return new ResponseEntity((Object)UserDto.fromUser(this.userRepository.findByUsername(username)), HttpStatus.OK);
    }

    @ApiOperation(value="Creates a new User")
    @RequestMapping(method={RequestMethod.POST}, value={"/user/acceptTermsAndCondition"}, consumes={"application/json"})
    public ResponseEntity<Boolean> acceptTermsAndCondition(Principal user) {
        OAuth2Authentication oauth2User = (OAuth2Authentication)user;
        if (this.userRepository.findByUsername(oauth2User.getName()) != null) {
            return new ResponseEntity((Object)false, HttpStatus.CREATED);
        }
        this.LOGGER.info("User: '{}' accepted the terms and conditions.", (Object)oauth2User.getName());
        this.accountService.create(oauth2User.getName());
        return new ResponseEntity((Object)true, HttpStatus.CREATED);
    }

    @ApiOperation(value="Deletes the user's user account")
    @RequestMapping(value={"/users/{username:.+}"}, method={RequestMethod.DELETE})
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#username,'user:delete')")
    public ResponseEntity<Void> deleteAccount(@PathVariable(value="username") String username) {
        this.accountService.delete(username);
        return new ResponseEntity(HttpStatus.OK);
    }
}

