/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.security.Principal;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.vorto.repository.account.IUserAccountService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(value="Home Controller", description="REST API to get currently logged in User ")
@RestController
public class HomeController {
    private static final String LOGIN_TYPE = "loginType";
    @Value(value="${github.oauth2.enabled}")
    private boolean githubEnabled;
    @Value(value="${eidp.oauth2.enabled}")
    private boolean eidpEnabled;
    @Value(value="${webEditor.enabled}")
    private boolean webEditorEnabled;
    @Value(value="${webEditor.loginUrl.github}")
    private String githubLoginUrl;
    @Value(value="${webEditor.loginUrl.eidp}")
    private String eidpLoginUrl;
    @Value(value="${webEditor.loginUrl.default}")
    private String defaultLoginUrl;
    @Autowired
    private IUserAccountService accountService;

    @ApiOperation(value="Returns the currently logged in User")
    @ApiResponses(value={@ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=200, message="OK")})
    @RequestMapping(value={"/user", "/me"}, method={RequestMethod.GET})
    public ResponseEntity<Map<String, String>> getUser(Principal user, HttpServletRequest request) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (user == null) {
            return new ResponseEntity(map, HttpStatus.UNAUTHORIZED);
        }
        OAuth2Authentication oauth2User = (OAuth2Authentication)user;
        oauth2User.getAuthorities().stream().findFirst().ifPresent(role -> map.put("role", role.getAuthority()));
        map.put("name", oauth2User.getName());
        map.put("isRegistered", Boolean.toString(this.accountService.exists(oauth2User.getName())));
        Map userDetails = (Map)oauth2User.getUserAuthentication().getDetails();
        map.put(LOGIN_TYPE, (String)userDetails.get(LOGIN_TYPE));
        return new ResponseEntity(map, HttpStatus.OK);
    }

    @RequestMapping(value={"/context"}, method={RequestMethod.GET})
    public Map<String, Object> globalContext() {
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>();
        context.put("githubEnabled", this.githubEnabled);
        context.put("eidpEnabled", this.eidpEnabled);
        context.put("webEditor", this.getWebEditorContext());
        return context;
    }

    public Map<String, Object> getWebEditorContext() {
        LinkedHashMap<String, Object> webEditorContext = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> loginContext = new LinkedHashMap<String, String>();
        loginContext.put("default", this.defaultLoginUrl);
        loginContext.put("github", this.githubLoginUrl);
        loginContext.put("eidp", this.eidpLoginUrl);
        webEditorContext.put("enabled", this.webEditorEnabled);
        webEditorContext.put("loginUrl", loginContext);
        return webEditorContext;
    }
}

