/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.upgrade.impl;

import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import org.eclipse.vorto.repository.upgrade.IUpgradeService;
import org.eclipse.vorto.repository.upgrade.IUpgradeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultUpgradeService
implements IUpgradeService {
    @Autowired
    private List<IUpgradeTask> tasks;
    private static final Logger logger = LoggerFactory.getLogger(DefaultUpgradeService.class);

    @Override
    @PostConstruct
    public void installUpgrades() {
        logger.info("Performing upgrade to the Vorto Repository and its content...");
        for (IUpgradeTask task : this.tasks) {
            if (!task.condition().isPresent() || task.condition().get().shouldExecuteTask()) {
                logger.info("Executing task - " + task.getShortDescription());
                try {
                    task.doUpgrade();
                }
                catch (IUpgradeTask.UpgradeProblem problem) {
                    logger.error("Problem executing upgrade task", (Throwable)problem);
                }
                continue;
            }
            logger.info("NOT Executing task - " + task.getShortDescription() + ". Conditions not met.");
        }
    }

    public void addTasks(IUpgradeTask ... tasks) {
        this.tasks = Arrays.asList(tasks);
    }
}

