/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.upgrade;

import java.util.Optional;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.core.impl.JcrModelRepository;
import org.eclipse.vorto.repository.core.impl.ModelEMFResource;
import org.eclipse.vorto.repository.upgrade.IUpgradeTask;
import org.eclipse.vorto.repository.upgrade.IUpgradeTaskCondition;

public abstract class AbstractUpgradeTask
implements IUpgradeTask {
    private IModelRepository modelRepository;

    public AbstractUpgradeTask(IModelRepository repository) {
        this.modelRepository = repository;
    }

    @Override
    public Optional<IUpgradeTaskCondition> condition() {
        return Optional.empty();
    }

    protected IModelRepository getModelRepository() {
        return this.modelRepository;
    }

    protected ModelEMFResource getModel(ModelId modelId) {
        return ((JcrModelRepository)this.modelRepository).getEMFResource(modelId);
    }

    protected void saveModel(ModelEMFResource resource) {
        ((JcrModelRepository)this.modelRepository).saveModel(resource);
    }
}

