/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.sso.boschid;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vorto.repository.sso.boschid.Interceptor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;

public class JwtTokenUserInfoServices
extends UserInfoTokenServices {
    private Interceptor interceptor;
    private OAuth2RestOperations restTemplate;
    private String clientId;
    private Gson gson = new Gson();

    public JwtTokenUserInfoServices(String userInfoEndpointUrl, String clientId) {
        super(userInfoEndpointUrl, clientId);
        this.clientId = clientId;
    }

    public JwtTokenUserInfoServices(String userInfoEndpointUrl, String clientId, Interceptor interceptor) {
        this(userInfoEndpointUrl, clientId);
        this.interceptor = interceptor;
    }

    public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException, InvalidTokenException {
        OAuth2Authentication auth = this.authenticationFromToken(this.getMap(accessToken));
        if (this.interceptor != null) {
            this.interceptor.intercept(this.restTemplate, auth, accessToken);
        }
        return auth;
    }

    private OAuth2Authentication authenticationFromToken(Map<String, String> map) {
        OAuth2Request request = new OAuth2Request(null, this.clientId, null, true, null, null, null, null, null);
        String nameFromEmail = map.get("email").split("@")[0];
        UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken((Object)nameFromEmail, (Object)"N/A", (Collection)AuthorityUtils.commaSeparatedStringToAuthorityList((String)"ROLE_USER"));
        HashMap<String, String> detailsMap = new HashMap<String, String>();
        detailsMap.put("sub", map.get("sub"));
        detailsMap.put("name", nameFromEmail);
        detailsMap.put("given_name", map.get("email"));
        detailsMap.put("last_name", map.get("email"));
        detailsMap.put("email", map.get("email"));
        authToken.setDetails(detailsMap);
        return new OAuth2Authentication(request, (Authentication)authToken);
    }

    private Map<String, String> getMap(String accessToken) {
        String[] jwtParts = accessToken.split("\\.");
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        return (Map)this.gson.fromJson(new String(Base64.getUrlDecoder().decode(jwtParts[1])), type);
    }

    public void setRestTemplate(OAuth2RestOperations restTemplate) {
        this.restTemplate = restTemplate;
        super.setRestTemplate(restTemplate);
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
    }
}

