/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.core.impl.validation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.Param;
import org.eclipse.vorto.core.api.model.functionblock.RefParam;
import org.eclipse.vorto.core.api.model.functionblock.ReturnObjectType;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.api.model.model.ModelReference;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.core.impl.InvocationContext;
import org.eclipse.vorto.repository.core.impl.ModelEMFResource;
import org.eclipse.vorto.repository.core.impl.validation.IModelValidator;
import org.eclipse.vorto.repository.core.impl.validation.ValidationException;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class TypeImportValidation
implements IModelValidator {
    @Override
    public void validate(ModelInfo modelResource, InvocationContext context) throws ValidationException {
        ArrayList unImportedReferences = Lists.newArrayList();
        ModelEMFResource emfModel = (ModelEMFResource)modelResource;
        Model model = emfModel.getModel();
        if (model == null) {
            return;
        }
        if (model instanceof Entity) {
            unImportedReferences.addAll(this.getUnimportedProperties((EList<Property>)((Entity)model).getProperties(), (EList<ModelReference>)model.getReferences()));
        } else if (model instanceof FunctionblockModel) {
            unImportedReferences.addAll(this.validateFunctionBlock((FunctionblockModel)model));
        } else if (model instanceof InformationModel) {
            unImportedReferences.addAll(this.getUnimportedFunctionblocks((EList<FunctionblockProperty>)((InformationModel)model).getProperties(), (EList<ModelReference>)model.getReferences()));
        }
        unImportedReferences.forEach(ref -> System.out.println("Missing : " + ref));
        if (!unImportedReferences.isEmpty()) {
            throw new ValidationException(this.errorMessage(unImportedReferences), modelResource);
        }
    }

    private Collection<String> validateFunctionBlock(FunctionblockModel model) throws ValidationException {
        FunctionBlock functionBlock = model.getFunctionblock();
        ArrayList unImportedReferences = Lists.newArrayList();
        if (functionBlock.getConfiguration() != null) {
            unImportedReferences.addAll(this.getUnimportedProperties((EList<Property>)functionBlock.getConfiguration().getProperties(), (EList<ModelReference>)model.getReferences()));
        }
        if (functionBlock.getStatus() != null) {
            unImportedReferences.addAll(this.getUnimportedProperties((EList<Property>)functionBlock.getStatus().getProperties(), (EList<ModelReference>)model.getReferences()));
        }
        if (functionBlock.getFault() != null) {
            unImportedReferences.addAll(this.getUnimportedProperties((EList<Property>)functionBlock.getFault().getProperties(), (EList<ModelReference>)model.getReferences()));
        }
        if (functionBlock.getEvents() != null) {
            functionBlock.getEvents().forEach(event -> unImportedReferences.addAll(this.getUnimportedProperties((EList<Property>)event.getProperties(), (EList<ModelReference>)model.getReferences())));
        }
        if (functionBlock.getOperations() != null) {
            unImportedReferences.addAll(this.getUnimportedOperationReturnTypes((EList<Operation>)functionBlock.getOperations(), (EList<ModelReference>)model.getReferences()));
            functionBlock.getOperations().forEach(operation -> unImportedReferences.addAll(this.getUnimportedRefParams((EList<Param>)operation.getParams(), (EList<ModelReference>)model.getReferences())));
        }
        return unImportedReferences;
    }

    private Collection<String> getUnimportedProperties(EList<Property> properties, EList<ModelReference> importedRefs) {
        return this.getUnimportedReferences((Collection)properties, importedRefs, (Function)this::getPropertyTypeSignature, (Predicate)property -> property.getType() instanceof ObjectPropertyType);
    }

    private Collection<String> getUnimportedRefParams(EList<Param> params, EList<ModelReference> importedRefs) {
        return this.getUnimportedReferences((Collection)params, importedRefs, (Function)this::getRefParamTypeSignature, (Predicate)param -> param instanceof RefParam);
    }

    private Collection<String> getUnimportedOperationReturnTypes(EList<Operation> operations, EList<ModelReference> importedRefs) {
        return this.getUnimportedReferences((Collection)operations, importedRefs, (Function)this::getReturnObjectTypeSignature, (Predicate)operation -> operation.getReturnType() instanceof ReturnObjectType);
    }

    private Collection<String> getUnimportedFunctionblocks(EList<FunctionblockProperty> functionBlocks, EList<ModelReference> importedRefs) {
        return this.getUnimportedReferences((Collection)functionBlocks, importedRefs, (Function)this::getFunctionBlockTypeSignature, null);
    }

    private <K> Collection<String> getUnimportedReferences(Collection<K> references, EList<ModelReference> importedRefs, Function<K, String> sigFunc, Predicate<K> primaryFilter) {
        assert (sigFunc != null);
        if (references == null) {
            return Collections.emptyList();
        }
        if (importedRefs == null) {
            return references.stream().map(sigFunc).collect(Collectors.toList());
        }
        Predicate<K> notInImports = this.inImports(importedRefs, sigFunc).negate();
        Predicate<K> filter = primaryFilter != null ? primaryFilter.and(notInImports) : notInImports;
        return references.stream().filter(filter).map(sigFunc).collect(Collectors.toList());
    }

    private String errorMessage(Collection<String> unImportedTypes) {
        return String.format("The following property (properties) %s has not been imported (not in the \"using\" statement).", unImportedTypes.stream().collect(Collectors.joining(",", "[", "]")));
    }

    private <K> Predicate<K> inImports(EList<ModelReference> importedRefs, Function<K, String> signatureFunction) {
        return reference -> importedRefs.stream().anyMatch(importedRef -> this.sameReference((ModelReference)importedRef, (String)signatureFunction.apply(reference)));
    }

    private boolean sameReference(ModelReference reference, String signature) {
        String referenceSignature = reference.getImportedNamespace();
        if (signature.split(Pattern.quote(".")).length > 1) {
            return signature.equals(referenceSignature);
        }
        String[] referenceTypeNameComponents = referenceSignature.split(Pattern.quote("."));
        return signature.equals(referenceTypeNameComponents[referenceTypeNameComponents.length - 1]);
    }

    private String getReturnObjectTypeSignature(Operation operation) {
        return NodeModelUtils.getTokenText((INode)NodeModelUtils.getNode((EObject)operation.getReturnType()).getLastChild());
    }

    private String getRefParamTypeSignature(Param refParam) {
        return this.getNamespace(NodeModelUtils.getTokenText((INode)NodeModelUtils.getNode((EObject)refParam).getLastChild()));
    }

    private String getPropertyTypeSignature(Property property) {
        return NodeModelUtils.getTokenText((INode)NodeModelUtils.getNode((EObject)((ObjectPropertyType)property.getType())));
    }

    private String getFunctionBlockTypeSignature(FunctionblockProperty fb) {
        return this.getNamespace(NodeModelUtils.getTokenText((INode)NodeModelUtils.getNode((EObject)fb)));
    }

    private String getNamespace(String text) {
        Pattern pattern = Pattern.compile("[aA][sS](\\s)+((\\w+\\.)*\\w+)\\s*");
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return text;
    }
}

