/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.core.impl.validation;

import org.eclipse.vorto.repository.account.Role;
import org.eclipse.vorto.repository.account.impl.IUserRepository;
import org.eclipse.vorto.repository.account.impl.User;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.core.impl.InvocationContext;
import org.eclipse.vorto.repository.core.impl.validation.IModelValidator;
import org.eclipse.vorto.repository.core.impl.validation.ValidationException;

public class DuplicateModelValidation
implements IModelValidator {
    private IModelRepository modelRepository;
    private IUserRepository userRepository;

    public DuplicateModelValidation(IModelRepository modelRepository, IUserRepository userRepo) {
        this.modelRepository = modelRepository;
        this.userRepository = userRepo;
    }

    @Override
    public void validate(ModelInfo modelResource, InvocationContext context) throws ValidationException {
        ModelInfo existingModel = this.modelRepository.getById(modelResource.getId());
        if (existingModel != null && !this.isAdmin(context) && !this.isAuthor(existingModel, context)) {
            throw new ValidationException("Model already exists", modelResource);
        }
    }

    private boolean isAdmin(InvocationContext context) {
        assert (context != null);
        assert (context.getUserContext() != null);
        assert (context.getUserContext().getUsername() != null);
        assert (this.userRepository != null);
        User user = this.userRepository.findByUsername(context.getUserContext().getUsername());
        return user != null && user.getRole() != null && user.getRole().equals((Object)Role.ADMIN);
    }

    private boolean isAuthor(ModelInfo model, InvocationContext context) {
        assert (context != null);
        assert (context.getUserContext() != null);
        return model.getAuthor().equalsIgnoreCase(context.getUserContext().getHashedUsername());
    }
}

