/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.core.impl.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.eclipse.vorto.repository.core.FatalModelRepositoryException;
import org.springframework.stereotype.Component;

@Component
public class ModelSearchUtil {
    public static final String SEARCH_FILTER_TYPE_INFORMATION_MODEL = "InformationModel";
    public static final String SEARCH_FILTER_TYPE_FUNCTION_BLOCK = "Functionblock";
    public static final String SEARCH_FILTER_TYPE_DATA_TYPE = "Datatype";
    public static final String[] SEARCH_FILTER_TYPE_LIST = new String[]{"Datatype", "Functionblock", "InformationModel"};
    public static final String SEARCH_FILTER_KEY_NAME = "name:";
    public static final String SEARCH_FILTER_KEY_NAMESPACE = "namespace:";
    public static final String SEARCH_FILTER_KEY_VERSION = "version:";
    public static final String SEARCH_FILTER_KEY_AUTHOR = "author:";
    public static final String[] SEARCH_FILTER_KEY_LIST = new String[]{"name:", "namespace:", "version:", "author:"};
    public final String VORTO_DISPLAYNAME = "vorto:displayname";
    public final String VORTO_NAMESPACE = "vorto:namespace";
    public final String VORTO_VERSION = "vorto:version";
    public final String VORTO_AUTHOR = "vorto:author";
    public final String VORTO_TYPE = "vorto:type";
    public final String SOURCE = "[nt:file]";
    public final String SELECT_QUERY = "SELECT * FROM [nt:file] WHERE ";
    public final String AND = "AND";
    public final String OR = "OR";
    private HashMap<String, ArrayList<String>> searchCriteriaParameterMap = new HashMap();
    private HashMap<String, String> map = new HashMap();

    public ModelSearchUtil() {
        this.map.put(SEARCH_FILTER_KEY_NAME, "vorto:displayname");
        this.map.put(SEARCH_FILTER_KEY_NAMESPACE, "vorto:namespace");
        this.map.put(SEARCH_FILTER_KEY_VERSION, "vorto:version");
        this.map.put(SEARCH_FILTER_KEY_AUTHOR, "vorto:author");
    }

    public SearchStrategy getSearchStrategy(String queryExpression) {
        this.searchCriteriaParameterMap.clear();
        for (String string : SEARCH_FILTER_KEY_LIST) {
            if (!queryExpression.contains(string)) continue;
            return SearchStrategy.FILTERED;
        }
        return SearchStrategy.FULL_TEXT;
    }

    public String getJCRStatementQuery(String queryExpression) {
        String[] array;
        if (this.getSearchStrategy(queryExpression) == SearchStrategy.FULL_TEXT) {
            return queryExpression;
        }
        for (String string : SEARCH_FILTER_TYPE_LIST) {
            if (!queryExpression.contains(string)) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.searchCriteriaParameterMap.put("vorto:type", arrayList);
            break;
        }
        for (String string : array = queryExpression.split("\\s+")) {
            for (String filter : SEARCH_FILTER_KEY_LIST) {
                if (!string.startsWith(filter)) continue;
                this.addToSearchCriteriaParameterMap(filter, string.replace(filter, ""));
            }
        }
        return this.buildJCRSearchQuery();
    }

    private void addToSearchCriteriaParameterMap(String key, String value) {
        if (this.searchCriteriaParameterMap.containsKey(key)) {
            ArrayList<String> arrayList = this.searchCriteriaParameterMap.get(key);
            arrayList.add(value);
            this.searchCriteriaParameterMap.put(key, arrayList);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(value);
            this.searchCriteriaParameterMap.put(key, arrayList);
        }
    }

    private String buildJCRSearchQuery() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT * FROM [nt:file] WHERE ");
        for (Map.Entry<String, ArrayList<String>> entry : this.searchCriteriaParameterMap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            stringBuilder.append("[nt:file]").append(".");
            if (this.map.containsKey(entry.getKey())) {
                stringBuilder.append("[").append(this.map.get(entry.getKey())).append("]");
            } else {
                stringBuilder.append("[").append(entry.getKey()).append("]");
            }
            if (entry.getValue().size() == 1) {
                stringBuilder.append(" = ").append(this.getSearchCriteriaParametersAsString(entry.getValue()));
            } else {
                stringBuilder.append(" IN ").append(this.getSearchCriteriaParametersAsString(entry.getValue()));
            }
            stringBuilder.append(" ").append("AND").append(" ");
        }
        stringBuilder.replace(stringBuilder.lastIndexOf("AND"), stringBuilder.length() - 1, "");
        return stringBuilder.toString();
    }

    private String getSearchCriteriaParametersAsString(ArrayList<String> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        if (arrayList.isEmpty()) {
            return "''";
        }
        if (arrayList.size() == 1) {
            stringBuilder.append("'").append(arrayList.get(0)).append("'");
        } else {
            stringBuilder.append("(");
            for (String string : arrayList) {
                stringBuilder.append("'").append(string).append("', ");
            }
            stringBuilder.replace(stringBuilder.lastIndexOf(","), stringBuilder.length() - 1, "");
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public Query createQueryFromExpression(Session session, String queryExpression) {
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String jcrStatementQuery = this.getJCRStatementQuery(queryExpression);
            if (jcrStatementQuery.equals(queryExpression)) {
                return queryManager.createQuery(jcrStatementQuery, "search");
            }
            return queryManager.createQuery(jcrStatementQuery, "JCR-SQL2");
        }
        catch (RepositoryException repoException) {
            throw new FatalModelRepositoryException("Could not create query from expression", repoException);
        }
    }

    static enum SearchStrategy {
        FULL_TEXT("Full Text"),
        FILTERED("Filtered");

        private final String strategy;

        public String getStrategy() {
            return this.strategy;
        }

        private SearchStrategy(String strategy) {
            this.strategy = strategy;
        }
    }
}

