/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.core.impl.utils;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.vorto.repository.account.impl.IUserRepository;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.api.upload.UploadModelResult;
import org.eclipse.vorto.repository.core.FatalModelRepositoryException;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.core.impl.ITemporaryStorage;
import org.eclipse.vorto.repository.core.impl.InvocationContext;
import org.eclipse.vorto.repository.core.impl.ModelEMFResource;
import org.eclipse.vorto.repository.core.impl.UploadModelResultFactory;
import org.eclipse.vorto.repository.core.impl.UserContext;
import org.eclipse.vorto.repository.core.impl.parser.ModelParserFactory;
import org.eclipse.vorto.repository.core.impl.utils.DependencyManager;
import org.eclipse.vorto.repository.core.impl.validation.BulkModelDuplicateIdValidation;
import org.eclipse.vorto.repository.core.impl.validation.BulkModelReferencesValidation;
import org.eclipse.vorto.repository.core.impl.validation.DuplicateModelValidation;
import org.eclipse.vorto.repository.core.impl.validation.IModelValidator;
import org.eclipse.vorto.repository.core.impl.validation.ValidationException;
import org.eclipse.vorto.repository.web.core.exceptions.BulkUploadException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class BulkUploadHelper {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    public static final long TTL_TEMP_STORAGE_INSECONDS = 300L;
    private IModelRepository repositoryService;
    private IUserRepository userRepository;
    private ITemporaryStorage uploadStorage;

    public BulkUploadHelper(IModelRepository modelRepository, ITemporaryStorage storage, IUserRepository userRepository) {
        this.repositoryService = modelRepository;
        this.uploadStorage = storage;
        this.userRepository = userRepository;
    }

    public List<UploadModelResult> uploadMultiple(byte[] content, String zipFileName, String callerId) {
        if (!this.isValid(zipFileName)) {
            throw new FatalModelRepositoryException("Filename/type is invalid", null);
        }
        ZipParseResult parseResult = this.parseZipFile(content);
        try {
            Function<ModelInfo, UploadModelResult> convertToUploadModelResult = this.createConvertToUploadModelResultFn(this.constructBulkUploadValidators(parseResult.validModels), InvocationContext.create(UserContext.user(callerId)));
            Set validatedModelResults = parseResult.validModels.stream().map(convertToUploadModelResult).collect(Collectors.toSet());
            HashSet<Object> uploadedModelResults = new HashSet<Object>();
            uploadedModelResults.addAll(parseResult.invalidModels);
            uploadedModelResults.addAll(validatedModelResults);
            if (uploadedModelResults.stream().anyMatch(result -> !result.isValid())) {
                return new ArrayList<UploadModelResult>(uploadedModelResults);
            }
            DependencyManager dm = new DependencyManager(parseResult.validModels);
            return dm.getSorted().stream().map(this::convertToUploadModelResultWithUploadHandle).filter(result -> result.isPresent()).map(result -> (UploadModelResult)result.get()).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new BulkUploadException("Invalid zip file", e);
        }
    }

    private Optional<UploadModelResult> convertToUploadModelResultWithUploadHandle(ModelInfo modelInfo) {
        try {
            String handleId = UUID.randomUUID().toString() + modelInfo.getType().getExtension();
            String key = this.uploadStorage.store(handleId, ((ModelEMFResource)modelInfo).toDSL(), 300L).getKey();
            return Optional.of(UploadModelResult.valid((String)key, (ModelInfo)modelInfo));
        }
        catch (IOException e) {
            this.LOGGER.error("Exception thrown when getting DSL of " + modelInfo.toString(), (Throwable)e);
            return Optional.empty();
        }
    }

    private Function<ModelInfo, UploadModelResult> createConvertToUploadModelResultFn(List<IModelValidator> bulkUploadValidators, InvocationContext context) {
        return modelInfo -> {
            try {
                bulkUploadValidators.stream().forEach(validator -> validator.validate((ModelInfo)modelInfo, context));
            }
            catch (ValidationException validationException) {
                return UploadModelResultFactory.create(validationException);
            }
            return UploadModelResult.valid((ModelInfo)modelInfo);
        };
    }

    private ZipParseResult parseZipFile(byte[] content) {
        assert (content != null);
        ZipParseResult parsingResult = new ZipParseResult();
        parsingResult.invalidModels = new HashSet<UploadModelResult>();
        parsingResult.validModels = new HashSet<ModelInfo>();
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(content));
        ZipEntry entry = null;
        try {
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                try {
                    parsingResult.validModels.add(ModelParserFactory.getParser(entry.getName()).parse(new ByteArrayInputStream(BulkUploadHelper.copyStream(zis, entry))));
                }
                catch (ValidationException grammarProblem) {
                    parsingResult.invalidModels.add(UploadModelResultFactory.create(grammarProblem));
                }
                catch (UnsupportedOperationException grammarProblem) {}
            }
        }
        catch (IOException e) {
            throw new BulkUploadException("IOException while getting next entry from zip file", e);
        }
        return parsingResult;
    }

    private boolean isValid(String file) {
        return !StringUtils.isEmpty((Object)file) && StringUtils.endsWithIgnoreCase((String)file, (String)".zip");
    }

    private List<IModelValidator> constructBulkUploadValidators(Set<ModelInfo> modelResources) {
        LinkedList<IModelValidator> bulkUploadValidators = new LinkedList<IModelValidator>();
        bulkUploadValidators.add(new DuplicateModelValidation(this.repositoryService, this.userRepository));
        bulkUploadValidators.add(new BulkModelDuplicateIdValidation(this.repositoryService, modelResources));
        bulkUploadValidators.add(new BulkModelReferencesValidation(this.repositoryService, modelResources));
        return bulkUploadValidators;
    }

    protected static byte[] copyStream(ZipInputStream in, ZipEntry entry) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int size;
            byte[] buffer = new byte[2048];
            BufferedOutputStream bos = new BufferedOutputStream(out);
            while ((size = in.read(buffer, 0, buffer.length)) != -1) {
                bos.write(buffer, 0, size);
            }
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            throw new BulkUploadException("IOException while copying stream to ZipEntry", e);
        }
        return out.toByteArray();
    }

    private class ZipParseResult {
        Set<UploadModelResult> invalidModels;
        Set<ModelInfo> validModels;

        private ZipParseResult() {
        }
    }
}

