/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.core.impl.parser;

import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.vorto.repository.core.impl.parser.DatatypeModelParser;
import org.eclipse.vorto.repository.core.impl.parser.FunctionblockModelParser;
import org.eclipse.vorto.repository.core.impl.parser.IModelParser;
import org.eclipse.vorto.repository.core.impl.parser.InformationModelParser;
import org.eclipse.vorto.repository.core.impl.parser.MappingModelParser;

public class ModelParserFactory {
    public static IModelParser getParser(String fileName) {
        if (fileName.endsWith(ModelType.Datatype.getExtension())) {
            return new DatatypeModelParser(fileName);
        }
        if (fileName.endsWith(ModelType.Functionblock.getExtension())) {
            return new FunctionblockModelParser(fileName);
        }
        if (fileName.endsWith(ModelType.InformationModel.getExtension())) {
            return new InformationModelParser(fileName);
        }
        if (fileName.endsWith(ModelType.Mapping.getExtension())) {
            return new MappingModelParser(fileName);
        }
        throw new UnsupportedOperationException("File cannot be parsed, because it is not supported");
    }

    public static boolean hasParserFor(String fileName) {
        return fileName.endsWith(ModelType.Datatype.getExtension()) || fileName.endsWith(ModelType.Functionblock.getExtension()) || fileName.endsWith(ModelType.InformationModel.getExtension()) || fileName.endsWith(ModelType.Mapping.getExtension());
    }
}

