/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.core.impl;

import java.util.Date;

public class StorageItem {
    private long timeToLive = -1L;
    private String key = null;
    private Object value = null;
    private Date creationDate = null;

    public StorageItem(String key, Object value, Date creationDate, long timeToLive) {
        this.key = key;
        this.value = value;
        this.creationDate = creationDate;
        this.timeToLive = timeToLive;
    }

    public String getKey() {
        return this.key;
    }

    public Date getExpiryDate() {
        long expiry = this.getCreationDate().getTime() + this.getTimeToLive() * 1000L;
        return new Date(expiry);
    }

    public Object getValue() {
        return this.value;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public boolean isExpired() {
        return new Date().after(this.getExpiryDate());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.creationDate == null ? 0 : this.creationDate.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (int)(this.timeToLive ^ this.timeToLive >>> 32);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageItem other = (StorageItem)obj;
        if (this.creationDate == null ? other.creationDate != null : !this.creationDate.equals(other.creationDate)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.timeToLive != other.timeToLive) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "StorageItem [timeToLive=" + this.timeToLive + ", key=" + this.key + ", value=" + this.value + ", creationDate=" + this.creationDate + "]";
    }
}

