/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.core.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.jcr.Binary;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.eclipse.vorto.repository.account.impl.IUserRepository;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.api.ModelType;
import org.eclipse.vorto.repository.api.exception.ModelNotFoundException;
import org.eclipse.vorto.repository.api.upload.UploadModelResult;
import org.eclipse.vorto.repository.core.FatalModelRepositoryException;
import org.eclipse.vorto.repository.core.IModelContent;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.core.IUserContext;
import org.eclipse.vorto.repository.core.ModelReferentialIntegrityException;
import org.eclipse.vorto.repository.core.impl.DefaultModelContent;
import org.eclipse.vorto.repository.core.impl.ITemporaryStorage;
import org.eclipse.vorto.repository.core.impl.InvocationContext;
import org.eclipse.vorto.repository.core.impl.ModelEMFResource;
import org.eclipse.vorto.repository.core.impl.StorageItem;
import org.eclipse.vorto.repository.core.impl.UploadModelResultFactory;
import org.eclipse.vorto.repository.core.impl.parser.ModelParserFactory;
import org.eclipse.vorto.repository.core.impl.utils.ModelIdHelper;
import org.eclipse.vorto.repository.core.impl.utils.ModelReferencesHelper;
import org.eclipse.vorto.repository.core.impl.utils.ModelSearchUtil;
import org.eclipse.vorto.repository.core.impl.validation.DuplicateModelValidation;
import org.eclipse.vorto.repository.core.impl.validation.IModelValidator;
import org.eclipse.vorto.repository.core.impl.validation.ModelReferencesValidation;
import org.eclipse.vorto.repository.core.impl.validation.TypeImportValidation;
import org.eclipse.vorto.repository.core.impl.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JcrModelRepository
implements IModelRepository {
    public static final long TTL_TEMP_STORAGE_INSECONDS = 300L;
    @Autowired
    private Session session;
    @Autowired
    private IUserRepository userRepository;
    @Autowired
    private ModelSearchUtil modelSearchUtil;
    @Autowired
    private ITemporaryStorage uploadStorage;
    private List<IModelValidator> validators = new LinkedList<IModelValidator>();
    private static Logger logger = Logger.getLogger(JcrModelRepository.class);

    @Override
    public List<ModelInfo> search(String expression) {
        String queryExpression = expression;
        if (queryExpression == null || queryExpression.isEmpty()) {
            queryExpression = "*";
        }
        try {
            ArrayList<ModelInfo> modelResources = new ArrayList<ModelInfo>();
            Query query = this.modelSearchUtil.createQueryFromExpression(this.session, queryExpression);
            logger.debug((Object)("Searching repository with expression " + query.getStatement()));
            QueryResult result = query.execute();
            RowIterator rowIterator = result.getRows();
            while (rowIterator.hasNext()) {
                Row row = rowIterator.nextRow();
                Node currentNode = row.getNode();
                if (!currentNode.hasProperty("vorto:type")) continue;
                try {
                    modelResources.add(this.createMinimalModelInfo(currentNode));
                }
                catch (Exception exception) {}
            }
            return modelResources;
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Could not create query manager", e);
        }
    }

    private ModelInfo createMinimalModelInfo(Node node) throws RepositoryException {
        NodeIterator imageNodeIterator;
        ModelInfo resource = new ModelInfo(ModelIdHelper.fromPath(node.getParent().getPath()), ModelType.valueOf((String)node.getProperty("vorto:type").getString()));
        resource.setDescription(node.getProperty("vorto:description").getString());
        resource.setDisplayName(node.getProperty("vorto:displayname").getString());
        resource.setCreationDate(node.getProperty("jcr:created").getDate().getTime());
        if (node.hasProperty("vorto:author")) {
            resource.setAuthor(node.getProperty("vorto:author").getString());
        }
        if ((imageNodeIterator = node.getParent().getNodes("img.png*")).hasNext()) {
            resource.setHasImage(true);
        }
        return resource;
    }

    private ModelInfo createModelResource(Node node) throws RepositoryException {
        ModelInfo resource = this.createMinimalModelInfo(node);
        if (node.hasProperty("vorto:references")) {
            Value[] referenceValues = null;
            try {
                referenceValues = node.getProperty("vorto:references").getValues();
            }
            catch (Exception ex) {
                referenceValues = new Value[]{node.getProperty("vorto:references").getValue()};
            }
            if (referenceValues != null) {
                ModelReferencesHelper referenceHelper = new ModelReferencesHelper();
                for (Value referValue : referenceValues) {
                    String nodeUuid = referValue.getString();
                    Node referencedNode = this.session.getNodeByIdentifier(nodeUuid);
                    referenceHelper.addModelReference(ModelIdHelper.fromPath(referencedNode.getParent().getPath()).getPrettyFormat());
                }
                resource.setReferences(referenceHelper.getReferences());
            }
        }
        PropertyIterator propIter = node.getReferences();
        while (propIter.hasNext()) {
            Property prop = propIter.nextProperty();
            Node referencedByFileNode = prop.getParent();
            ModelId referencedById = ModelIdHelper.fromPath(referencedByFileNode.getParent().getPath());
            resource.getReferencedBy().add(referencedById);
            if (!referencedByFileNode.getName().endsWith(ModelType.Mapping.getExtension())) continue;
            ModelEMFResource emfResource = this.getEMFResource(referencedById);
            resource.addPlatformMapping(emfResource.getTargetPlatform(), referencedById);
        }
        return resource;
    }

    @Override
    public IModelContent getModelContent(ModelId modelId, IModelRepository.ContentType contentType) {
        try {
            ModelIdHelper modelIdHelper = new ModelIdHelper(modelId);
            Node folderNode = this.session.getNode(modelIdHelper.getFullPath());
            Node fileNode = (Node)folderNode.getNodes(modelId.getName() + "*").next();
            Node fileItem = (Node)fileNode.getPrimaryItem();
            InputStream is = fileItem.getProperty("jcr:data").getBinary().getStream();
            ModelEMFResource resource = (ModelEMFResource)ModelParserFactory.getParser(fileNode.getName()).parse(is);
            if (contentType == IModelRepository.ContentType.XMI) {
                return new DefaultModelContent(resource.getModel(), contentType, resource.toXMI());
            }
            return new DefaultModelContent(resource.getModel(), contentType, resource.toDSL());
        }
        catch (PathNotFoundException e) {
            throw new ModelNotFoundException("Could not find model with the given model id", (Throwable)e);
        }
        catch (Exception e) {
            throw new FatalModelRepositoryException("Something went wrong accessing the repository", e);
        }
    }

    @Override
    public UploadModelResult upload(byte[] content, String fileName, IUserContext userContext) {
        try {
            ModelInfo resource = ModelParserFactory.getParser(fileName).parse(new ByteArrayInputStream(content));
            ArrayList<ValidationException> validationExceptions = new ArrayList<ValidationException>();
            for (IModelValidator validator : this.validators) {
                try {
                    validator.validate(resource, InvocationContext.create(userContext));
                }
                catch (ValidationException validationException) {
                    validationExceptions.add(validationException);
                }
            }
            if (validationExceptions.size() <= 0) {
                return UploadModelResult.valid((String)this.createUploadHandle(content, resource.getType()), (ModelInfo)resource);
            }
            return UploadModelResultFactory.create(validationExceptions.toArray(new ValidationException[validationExceptions.size()]));
        }
        catch (ValidationException e) {
            return UploadModelResultFactory.invalid(e);
        }
    }

    private String createUploadHandle(byte[] content, ModelType type) {
        String handleId = UUID.randomUUID().toString() + type.getExtension();
        return this.uploadStorage.store(handleId, content, 300L).getKey();
    }

    @Override
    public ModelInfo checkin(String handleId, IUserContext userContext) {
        StorageItem uploadedItem = this.uploadStorage.get(handleId);
        if (uploadedItem == null) {
            throw new IllegalArgumentException("No model found for handleId '" + handleId + "'");
        }
        ModelInfo resource = ModelParserFactory.getParser(handleId).parse(new ByteArrayInputStream((byte[])uploadedItem.getValue()));
        try {
            Node fileNode;
            Node folderNode = this.createNodeForModelId(resource.getId());
            Node node = fileNode = folderNode.getNodes("*.type | *.fbmodel | *.infomodel | *.mapping").hasNext() ? folderNode.getNodes("*.type | *.fbmodel | *.infomodel | *.mapping").nextNode() : null;
            if (fileNode == null) {
                fileNode = folderNode.addNode(resource.getId().getName() + resource.getType().getExtension(), "nt:file");
                fileNode.addMixin("vorto:meta");
                fileNode.addMixin("mix:referenceable");
                fileNode.setProperty("vorto:author", userContext.getHashedUsername());
                Node contentNode = fileNode.addNode("jcr:content", "nt:resource");
                Binary binary = this.session.getValueFactory().createBinary((InputStream)new ByteArrayInputStream((byte[])uploadedItem.getValue()));
                contentNode.setProperty("jcr:data", binary);
            } else {
                fileNode.setProperty("vorto:author", userContext.getHashedUsername());
                Node contentNode = fileNode.getNode("jcr:content");
                Binary binary = this.session.getValueFactory().createBinary((InputStream)new ByteArrayInputStream((byte[])uploadedItem.getValue()));
                contentNode.setProperty("jcr:data", binary);
            }
            this.session.save();
            logger.info((Object)"Checkin successful");
            this.uploadStorage.remove(handleId);
        }
        catch (Exception e) {
            logger.error((Object)"Error checking in model", (Throwable)e);
            throw new FatalModelRepositoryException("Problem checking in uploaded model" + resource.getId(), e);
        }
        return resource;
    }

    private Node createNodeForModelId(ModelId id) throws RepositoryException {
        ModelIdHelper modelIdHelper = new ModelIdHelper(id);
        StringBuilder pathBuilder = new StringBuilder();
        Iterator<String> modelIdIterator = modelIdHelper.iterator();
        Node rootNode = this.session.getRootNode();
        while (modelIdIterator.hasNext()) {
            String nextPathFragment = modelIdIterator.next();
            pathBuilder.append(nextPathFragment).append("/");
            try {
                rootNode.getNode(pathBuilder.toString());
            }
            catch (PathNotFoundException pathNotFound) {
                Node addedNode = rootNode.addNode(pathBuilder.toString(), "nt:folder");
                addedNode.setPrimaryType("nt:folder");
            }
        }
        return rootNode.getNode(modelIdHelper.getFullPath().substring(1));
    }

    @Override
    public ModelInfo getById(ModelId modelId) {
        try {
            NodeIterator imageNodeIterator;
            ModelIdHelper modelIdHelper = new ModelIdHelper(modelId);
            Node folderNode = this.session.getNode(modelIdHelper.getFullPath());
            Node modelFileNode = folderNode.getNodes("*.type | *.fbmodel | *.infomodel | *.mapping").nextNode();
            ModelInfo modelResource = this.createModelResource(modelFileNode);
            if (modelResource.getType() == ModelType.InformationModel && (imageNodeIterator = folderNode.getNodes("img.png*")).hasNext()) {
                modelResource.setHasImage(true);
            }
            return modelResource;
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Retrieving Content of Resource: Problem accessing repository", e);
        }
    }

    @PostConstruct
    public void createValidators() {
        this.validators.add(new DuplicateModelValidation(this, this.userRepository));
        this.validators.add(new ModelReferencesValidation(this));
        this.validators.add(new TypeImportValidation());
    }

    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    public List<ModelInfo> getMappingModelsForTargetPlatform(ModelId modelId, String targetPlatform) {
        ArrayList<ModelInfo> mappingResources = new ArrayList<ModelInfo>();
        ModelInfo modelResource = this.getById(modelId);
        if (modelResource != null) {
            for (ModelId referenceeModelId : modelResource.getReferencedBy()) {
                ModelInfo referenceeModelResources = this.getById(referenceeModelId);
                if (referenceeModelResources.getType() != ModelType.Mapping || !this.isTargetPlatformMapping(referenceeModelResources, targetPlatform)) continue;
                mappingResources.add(referenceeModelResources);
            }
            for (ModelId referencedModelId : modelResource.getReferences()) {
                mappingResources.addAll(this.getMappingModelsForTargetPlatform(referencedModelId, targetPlatform));
            }
        }
        return mappingResources;
    }

    private boolean isTargetPlatformMapping(ModelInfo model, String targetPlatform) {
        try {
            ModelEMFResource emfResource = this.getEMFResource(model.getId());
            return emfResource.matchesTargetPlatform(targetPlatform);
        }
        catch (Exception e) {
            throw new FatalModelRepositoryException("Something went wrong accessing the repository", e);
        }
    }

    public ModelEMFResource getEMFResource(ModelId modelId) {
        try {
            ModelIdHelper modelIdHelper = new ModelIdHelper(modelId);
            Node folderNode = this.session.getNode(modelIdHelper.getFullPath());
            Node fileNode = (Node)folderNode.getNodes().next();
            Node fileItem = (Node)fileNode.getPrimaryItem();
            InputStream is = fileItem.getProperty("jcr:data").getBinary().getStream();
            return (ModelEMFResource)ModelParserFactory.getParser(fileNode.getName()).parse(is);
        }
        catch (Exception e) {
            throw new FatalModelRepositoryException("Something went wrong accessing the repository", e);
        }
    }

    @Override
    public void addModelImage(ModelId modelId, byte[] imageContent) {
        try {
            Node imageNode;
            ModelIdHelper modelIdHelper = new ModelIdHelper(modelId);
            Node modelFolderNode = this.session.getNode(modelIdHelper.getFullPath());
            Node contentNode = null;
            if (modelFolderNode.hasNode("img.png")) {
                imageNode = modelFolderNode.getNode("img.png");
                contentNode = (Node)imageNode.getPrimaryItem();
            } else {
                imageNode = modelFolderNode.addNode("img.png", "nt:file");
                contentNode = imageNode.addNode("jcr:content", "nt:resource");
            }
            Binary binary = this.session.getValueFactory().createBinary((InputStream)new ByteArrayInputStream(imageContent));
            contentNode.setProperty("jcr:data", binary);
            this.session.save();
        }
        catch (PathNotFoundException e) {
            throw new ModelNotFoundException("Problem when trying to add image to model", (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new FatalModelRepositoryException("Something severe went wrong when accessing the repository", e);
        }
    }

    @Override
    public void removeModelImage(ModelId modelId) {
        try {
            ModelIdHelper modelIdHelper = new ModelIdHelper(modelId);
            Node modelFolderNode = this.session.getNode(modelIdHelper.getFullPath());
            if (modelFolderNode.hasNode("img.png")) {
                Node imageNode = modelFolderNode.getNode("img.png");
                imageNode.remove();
                this.session.save();
            }
        }
        catch (PathNotFoundException e) {
            throw new ModelNotFoundException("Problem when trying to remove image to model", (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new FatalModelRepositoryException("Something severe went wrong when accessing the repository", e);
        }
    }

    @Override
    public byte[] getModelImage(ModelId modelId) {
        try {
            ModelIdHelper modelIdHelper = new ModelIdHelper(modelId);
            Node folderNode = this.session.getNode(modelIdHelper.getFullPath());
            if (folderNode.hasNode("img.png")) {
                Node imageNode = folderNode.getNode("img.png");
                Node fileItem = (Node)imageNode.getPrimaryItem();
                InputStream is = fileItem.getProperty("jcr:data").getBinary().getStream();
                return IOUtils.toByteArray((InputStream)is);
            }
        }
        catch (PathNotFoundException e) {
            throw new ModelNotFoundException("Problem when trying to retrieve image for model", (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new FatalModelRepositoryException("Something severe went wrong when accessing the repository", e);
        }
        catch (IOException e) {
            throw new FatalModelRepositoryException("Something severe went wrong when trying to read image content", e);
        }
        return null;
    }

    @Override
    public void removeModel(ModelId modelId) {
        try {
            ModelInfo modelResource = this.getById(modelId);
            if (!modelResource.getReferencedBy().isEmpty()) {
                throw new ModelReferentialIntegrityException("Cannot remove model because it is referenced by other model(s)", modelResource.getReferencedBy());
            }
            ModelIdHelper modelIdHelper = new ModelIdHelper(modelId);
            Item item = this.session.getItem(modelIdHelper.getFullPath());
            item.remove();
            this.session.save();
        }
        catch (RepositoryException e) {
            throw new FatalModelRepositoryException("Problem occured removing the model", e);
        }
    }

    @Override
    public ModelInfo updateMeta(ModelInfo model) {
        try {
            Node folderNode = this.createNodeForModelId(model.getId());
            Node fileNode = folderNode.getNodes("*.type | *.fbmodel | *.infomodel | *.mapping").hasNext() ? folderNode.getNodes("*.type | *.fbmodel | *.infomodel | *.mapping").nextNode() : null;
            fileNode.setProperty("vorto:author", model.getAuthor());
            this.session.save();
            return model;
        }
        catch (RepositoryException e) {
            throw new FatalModelRepositoryException("Problem occured removing the model", e);
        }
    }

    public void saveModel(ModelEMFResource resource) {
        try {
            Node folderNode = this.createNodeForModelId(resource.getId());
            Node fileNode = folderNode.getNodes("*.type | *.fbmodel | *.infomodel | *.mapping").hasNext() ? folderNode.getNodes("*.type | *.fbmodel | *.infomodel | *.mapping").nextNode() : null;
            Node contentNode = fileNode.getNode("jcr:content");
            Binary binary = this.session.getValueFactory().createBinary((InputStream)new ByteArrayInputStream(resource.toDSL()));
            contentNode.setProperty("jcr:data", binary);
            this.session.save();
        }
        catch (Exception e) {
            throw new FatalModelRepositoryException("Problem occured removing the model", e);
        }
    }

    public ModelSearchUtil getModelSearchUtil() {
        return this.modelSearchUtil;
    }

    public void setModelSearchUtil(ModelSearchUtil modelSearchUtil) {
        this.modelSearchUtil = modelSearchUtil;
    }

    public IUserRepository getUserRepository() {
        return this.userRepository;
    }

    public void setUserRepository(IUserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public ITemporaryStorage getUploadStorage() {
        return this.uploadStorage;
    }

    public void setUploadStorage(ITemporaryStorage uploadStorage) {
        this.uploadStorage = uploadStorage;
    }
}

